package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiHKPersonalService;
import com.js.api.jspay.service.ApiKycCertiMainLandPersonalService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandPersonalReq;
import com.js.common.model.req.KycCertiHKPersonalReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycCertiHKPersonal;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.model.KycCertiMainLandPersonal;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycCertiLinkFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;


/**
 * @Author: liuh
 * @Create: 2019-05-31
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiHKPersonalServiceImpl extends IBaseServiceImpl<KycCertiHKPersonal> implements ApiKycCertiHKPersonalService {
    @Autowired
    KycCertiLinkFileService kycCertiLinkFileService;
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;

    @Override
    public ResponseMessage certiHKPersonalAdd(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO){
        log.info("香港个人-实名认证提交处理开始:{}", JSON.toJSONString(kycCertiHKPersonalReq));
        KycCertiHKPersonal kycCertiHKPersonal = new KycCertiHKPersonal();
        BeanUtils.copyProperties(kycCertiHKPersonalReq,kycCertiHKPersonal);

        kycCertiHKPersonal.setId(IdUtil.simpleUUID());
        kycCertiHKPersonal.setKycNaturalId(kycNaturalVO.getId());
        kycCertiHKPersonal.setCreateId(kycNaturalVO.getId());
        kycCertiHKPersonal.setIdType(kycCertiHKPersonalReq.getCertiCardType().name());
        kycCertiHKPersonal.setIdTypeName(kycCertiHKPersonalReq.getCertiCardType().getEnumName());
        kycCertiHKPersonal.setCreateName(kycNaturalVO.getCertificationName());
        kycCertiHKPersonal.setStatus(CertiStatusEnum.SUBMIT_WATING.getCode());

        super.insertSelective(kycCertiHKPersonal);
        List<KycCertiLinkFile> kycCertiLinkFileList = kycCertiLinkFileService.ConvertToKycCertiLinkFile(kycCertiHKPersonal.getId(), kycNaturalVO, kycCertiHKPersonalReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            kycCertiLinkFileService.insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-香港个人实名认证信息完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_WATING);
        kycNaturalReq.setRegisterType(RegisterType.HK_PERSONAL);
        kycNaturalReq.setCertificationName(kycCertiHKPersonalReq.getCusName());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);

        log.info("香港个人-保存寻汇用户信息-开始");
        kycCertiHKPersonalReq.setKycCertiId(kycCertiHKPersonal.getId());
        ResponseMessage responseMessage = apiSunrateRegisterService.xhRegister(kycCertiHKPersonalReq,kycNaturalVO);
        log.info("香港个人-保存寻汇用户信息-结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        return ResultUtil.success(kycCertiHKPersonal.getId());
    }

    @Override
    public boolean verifyCertiHKPersonalExists(String certificateNo) {
        KycCertiHKPersonal kycCertiHKPersonalQuery = new KycCertiHKPersonal();
        kycCertiHKPersonalQuery.setCertificateNo(certificateNo);
        KycCertiHKPersonal kycCertiHKPersonal = iBaseMapper.selectOne(kycCertiHKPersonalQuery);
        return null == kycCertiHKPersonal ? false : true;
    }
}
