package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiKycCertiHKCompanyService;
import com.js.api.jspay.service.ApiKycCertiMainLandCompanyService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateRegisterService;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.CertiMainLandCompanyReq;
import com.js.common.model.req.KycCertiHKCompanyReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycCertiHKCompany;
import com.js.dal.dao.model.KycCertiLinkFile;
import com.js.dal.dao.model.KycCertiMainLandCompany;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycCertiLinkFileService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Author: yjzhao
 * @Create: 2019-05-16  10:19
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiKycCertiHKCompanyServiceImpl extends IBaseServiceImpl<KycCertiHKCompany> implements ApiKycCertiHKCompanyService {
    @Autowired
    KycCertiLinkFileService kycCertiLinkFileService;
    @Autowired
    ApiKycNaturalService apiKycNaturalService;
    @Autowired
    ApiSunrateRegisterService apiSunrateRegisterService;

    @Override
    public ResponseMessage certiHKCompanyAdd(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO) {
        log.info("香港企业-实名认证提交处理开始:{}", JSON.toJSONString(kycCertiHKCompanyReq));
        KycCertiHKCompany kycCertiHKCompany = new KycCertiHKCompany();
        BeanUtils.copyProperties(kycCertiHKCompanyReq,kycCertiHKCompany);
        kycCertiHKCompany.setId(IdUtil.simpleUUID());
        kycCertiHKCompany.setKycNaturalId(kycNaturalVO.getId());
        kycCertiHKCompany.setCreateId(kycNaturalVO.getId());
        kycCertiHKCompany.setDirectorIdType(kycCertiHKCompanyReq.getCertiCardType().name());
        kycCertiHKCompany.setDirectorIdTypeName(kycCertiHKCompanyReq.getCertiCardType().getEnumName());
        kycCertiHKCompany.setCreateName(kycNaturalVO.getCertificationName());

        super.insertSelective(kycCertiHKCompany);
        List<KycCertiLinkFile> kycCertiLinkFileList = kycCertiLinkFileService.ConvertToKycCertiLinkFile(kycCertiHKCompany.getId(), kycNaturalVO, kycCertiHKCompanyReq.getKycCertiLinkFileReqList());
        for(KycCertiLinkFile kycCertiLinkFile : kycCertiLinkFileList){
            kycCertiLinkFileService.insertSelective(kycCertiLinkFile);
        }
        log.info("js方存储-香港企业实名认证信息完成");

        log.info("更新用户表实名状态开始");
        KycNaturalReq kycNaturalReq = new KycNaturalReq();
        kycNaturalReq.setId(kycNaturalVO.getId());
        kycNaturalReq.setCertificationStatus(CertiStatusEnum.SUBMIT_WATING);
        kycNaturalReq.setRegisterType(RegisterType.HK_COMPANY);
        kycNaturalReq.setCertificationName(kycCertiHKCompanyReq.getCompanyName());
        int updateCount = apiKycNaturalService.updateKycNatural(kycNaturalReq);
        log.info("更新用户表实名状态结束，更新条数：{}",updateCount);

        log.info("大陆企业-保存寻汇用户信息-开始");
        kycCertiHKCompanyReq.setKycCertiId(kycCertiHKCompany.getId());
        ResponseMessage responseMessage = apiSunrateRegisterService.xhRegister(kycCertiHKCompanyReq,kycNaturalVO);
        log.info("大陆企业-保存寻汇用户信息-结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        return ResultUtil.success(kycCertiHKCompany.getId());
    }

    @Override
    public boolean verifyCertiHKCompanyExists(String companyRegisteredCertificateNo) {
        KycCertiHKCompany kycCertiHKCompanyQuery = new KycCertiHKCompany();
        kycCertiHKCompanyQuery.setCompanyRegisteredCertificateNo(companyRegisteredCertificateNo);
        KycCertiHKCompany kycCertiHKCompany = iBaseMapper.selectOne(kycCertiHKCompanyQuery);
        return null == kycCertiHKCompany ? false : true;
    }
}
