package com.js.pay.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycDictionaryService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.SiteEnum;
import com.js.common.enums.SysPlateformType;
import com.js.common.enums.WayJdBankCheckEnum;
import com.js.common.model.req.KycBankReq;
import com.js.common.model.req.KycCheckBankReq;
import com.js.common.model.vo.KycBankVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.dal.dao.plugin.PageModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import com.js.api.jspay.service.ApiKycBankService;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycBank;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: 用户绑定银行卡
 * @Author: liuty
 * @Create: 2019-05-25
 */
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiKycBankServiceImpl extends IBaseServiceImpl<KycBank> implements ApiKycBankService {

    @Autowired
    ApiKycDictionaryService apiKycDictionaryService;

    @Value("${way.js.appkey}")
    private String wayJdAppkey;


    @Override
    public ResponseMessage addBankCard(KycBankReq kycBankReq, KycNaturalVO kycNaturalVO) {
        KycBank kycBankQuery = new KycBank();
        kycBankQuery.setKycNaturalId(kycNaturalVO.getId());
        kycBankQuery.setDelFlag(false);
        List<KycBank> kycBankList = iBaseMapper.select(kycBankQuery);
        boolean isFirstAdd = false;
        if(CollectionUtils.isEmpty(kycBankList)){
            isFirstAdd = true;
        }else {
            List<KycBank> existsList = kycBankList.stream().filter(kycBank -> kycBank.getAccountNo().equals(kycBankReq.getAccountNo())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(existsList)) {
                return ResultUtil.error(ResultEnum.MESSAGE_EXIST);
            }
            List<KycBank> hfgjList = kycBankList.stream().filter(kycBank -> SysPlateformType.HFGJ.equals(kycBank.getRouteType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(hfgjList)) {
                isFirstAdd = true;
            }
            kycBankList.stream().forEach(kycBank -> {
                if (kycBank.getMainFlag()) {
                    kycBank.setMainFlag(false);
                    iBaseMapper.updateByPrimaryKey(kycBank);
                }
            });
        }
        KycBank kycBankAdd = new KycBank();
        BeanUtil.copyProperties(kycBankReq,kycBankAdd);
        kycBankAdd.setId(IdUtil.simpleUUID());
        kycBankAdd.setKycNaturalId(kycNaturalVO.getId());
        kycBankAdd.setCreateId(kycNaturalVO.getId());
        kycBankAdd.setDelFlag(false);
        kycBankAdd.setMainFlag(true);
        kycBankAdd.setCreateName(kycNaturalVO.getCertificationName());
        kycBankAdd.setCreateDts(new Date());
        int insertCount = iBaseMapper.insert(kycBankAdd);
        log.info("银行卡添加成功,添加条数：{}",insertCount);
        return ResultUtil.success(isFirstAdd);
    }

    @Override
    public ResponseMessage disableBankCard(String bankId,KycNaturalVO kycNaturalVO) {
        KycBank kycBankQuery = new KycBank();
        kycBankQuery.setId(bankId);
        kycBankQuery.setKycNaturalId(kycNaturalVO.getId());
        KycBank kycBank = iBaseMapper.selectOne(kycBankQuery);
        if(null == kycBank){
            log.info("未查询到银行卡信息:{},{}",bankId,kycNaturalVO.getId());
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        kycBank.setDelFlag(true);
        int updateCount = iBaseMapper.updateByPrimaryKeySelective(kycBank);
        log.info("删除银行卡条数：{}",updateCount);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage getBankCard(String id) {
        if (ObjectUtil.isEmpty(id)) {
            return ResultUtil.error(id, ResultEnum.QUERY_ERROR);
        } else {
            KycBank kycBank = iBaseMapper.selectByPrimaryKey(id);
            KycBankVO kycBankVO = new KycBankVO();
            BeanUtil.copyProperties(kycBank, kycBankVO);
            return ResultUtil.success(kycBankVO, ResultEnum.QUERY_SUCCESS);
        }
    }

    @Override
    public String getBankCardList(KycBankCardReq kycBankCardReq) {
        PageModel pageModel = new PageModel();
        List<KycBank> kycBanks = iBaseMapper.selectByExample(new Example(KycBank.class));
        int count = kycBanks.size();
        if(count <= 0) {
            return JSON.toJSONString(pageModel);
        }
        if(!ObjectUtil.isEmpty(kycBanks)) {
            JSONArray array = new JSONArray();
            for(KycBank kycBank : kycBanks) {
                JSONObject object = (JSONObject) JSONObject.toJSON(kycBank);
                object.put("createTime", DateUtil.format(kycBank.getCreateDts(), "yyyyMMdd HH:mm:ss"));
                array.add(object);
            }
            pageModel.setList(array);
        }
        pageModel.setCount(count);
        pageModel.setMsg("ok");
        pageModel.setRel(true);
        return JSON.toJSONString(pageModel);
    }

    @Override
    public ResponseMessage getKycBankList(KycBankCardReq kycBankCardReq) {
        KycBank kycBankQuery = new KycBank();
        kycBankQuery.setDelFlag(false);
        kycBankQuery.setKycNaturalId(kycBankCardReq.getKycNaturalId());
        if(StringUtils.isNotBlank(kycBankCardReq.getCurrencyCode())){
            kycBankQuery.setCurrencyCode(kycBankCardReq.getCurrencyCode());
        }
        List<KycBank> kycBankList = iBaseMapper.select(kycBankQuery);
        List<KycBankVO> kycBankVOList = new ArrayList<>();
        kycBankList.stream().forEach(kycBank -> {
            KycBankVO kycBankVO = new KycBankVO();
            BeanUtils.copyProperties(kycBank,kycBankVO);
            String currencyCode = kycBank.getCurrencyCode();
            if(!CommonConstant.TRADE_CURRENCY_CNY.equals(currencyCode)){
                SiteEnum siteEnum = SiteEnum.getByCurrency(currencyCode);
                if(null != siteEnum){
                    kycBankVO.setCurrencyDesc(siteEnum.getHyDesc());
                }
            }
            kycBankVOList.add(kycBankVO);
        });
        return ResultUtil.success(kycBankVOList);
    }

    @Override
    public ResponseMessage getProvence() {
        return apiKycDictionaryService.findDictionary("PROVINCE", null);
    }

    @Override
    public ResponseMessage getCity(String provinceCode) {
        if (ObjectUtil.isEmpty(provinceCode)) {
            return ResultUtil.error("省份编码不许为空", ResultEnum.QUERY_ERROR);
        } else {
            return apiKycDictionaryService.findDictionary("CITY_" + provinceCode, null);
        }
    }

    @Override
    public ResponseMessage checkBank(KycCheckBankReq kycCheckBankReq) {
        if (!kycCheckBankReq.getUseReal()) {
            return ResultUtil.success(ResultEnum.BANK_CHECK_SUCCESS);
        }
        if (ObjectUtil.isEmpty(kycCheckBankReq.getAcctPan())
                || ObjectUtil.isEmpty(kycCheckBankReq.getAcctName()) ||
                ObjectUtil.isEmpty(kycCheckBankReq.getWayJdBankCheckEnum())) {
            return ResultUtil.error(ResultEnum.BANK_CHECK_FAILURE.getCode(), "参数校验未通过");
        }
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("appkey", wayJdAppkey);
        paramMap.put("needBelongArea", false);
        paramMap.put("acct_pan", kycCheckBankReq.getAcctPan());
        paramMap.put("acct_name", kycCheckBankReq.getAcctName());
        paramMap.put("cert_type", "01");
        paramMap.put("cert_id", kycCheckBankReq.getCertId());
        paramMap.put("phone_num", kycCheckBankReq.getPhoneNum());
        String code;
        if (kycCheckBankReq.getWayJdBankCheckEnum().equals(WayJdBankCheckEnum.THREE_ELEMENT)) {
            if (ObjectUtil.isEmpty(kycCheckBankReq.getCertId())) {
                return ResultUtil.error(ResultEnum.BANK_CHECK_FAILURE.getCode(), "请填写身份证号");
            }
        } else if (kycCheckBankReq.getWayJdBankCheckEnum().equals(WayJdBankCheckEnum.FOUR_ELEMENT)) {
            if (ObjectUtil.isEmpty(kycCheckBankReq.getPhoneNum())) {
                return ResultUtil.error(ResultEnum.BANK_CHECK_FAILURE.getCode(), "请填写手机号");
            }
        }
        String result = HttpUtil.post(kycCheckBankReq.getWayJdBankCheckEnum().getEndpoint(), paramMap);
        code = getCode(result);
        if ("0".equals(code)) {
            return ResultUtil.success(ResultEnum.BANK_CHECK_SUCCESS);
        } else {
            return ResultUtil.success(ResultEnum.BANK_CHECK_FAILURE);
        }
    }

    /**
     * 获取银行卡要素验证结果
     * @param result
     * @return
     */
    private String getCode(String result) {
        JSONObject jsonObject = JSONObject.parseObject(result);
        String code = jsonObject.getString("code");
        if (!"10000".equals(code)) {
            log.error(jsonObject.toJSONString());
        } else {
            Long remain = jsonObject.getLong("remain");
            log.info("银行卡要素认证剩余次数: {}", remain);
        }
        return jsonObject.getJSONObject("result")
                .getJSONObject("showapi_res_body")
                .getString("code");
    }
}
