package com.js.pay.service.impl;

import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsPayVatPaymentInfoService;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsPayVatPaymentRcvListReq;
import com.js.common.model.vo.JsPayStationOrganInfoVO;
import com.js.common.model.vo.KycStoreVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPayVatPaymentInfoMapper;
import com.js.dal.dao.mapper.KycStoreMapper;
import com.js.dal.dao.model.JsPayStationOrganInfo;
import com.js.dal.dao.model.JsPayVatPaymentInfo;
import com.js.dal.dao.model.KycSunrateBeneficiary;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsPayVatPaymentInfoServiceImpl extends IBaseServiceImpl<JsPayVatPaymentInfo> implements ApiJsPayVatPaymentInfoService {
    @Autowired
    JsPayVatPaymentInfoMapper jsPayVatPaymentInfoMapper;


    @Override
    public ResponseMessage queryRcvList(JsPayVatPaymentRcvListReq jsPayVatPaymentRcvListReq) {
        log.info("查询已添加的缴税局列表:{} start",jsPayVatPaymentRcvListReq.getTaxStationCountry());
        List<JsPayStationOrganInfoVO> vatPaymentList = jsPayVatPaymentInfoMapper.queryRcvList(jsPayVatPaymentRcvListReq);
        PageInfo<JsPayStationOrganInfoVO> pageInfo = new PageInfo<>(vatPaymentList);
        log.info("查询已添加的缴税局列表:{} end");
        return ResultUtil.success(pageInfo);
    }
}
