package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiJsPayTradeService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPayTradeReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsPayTrade;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @Description: 交易流水操作具体实现
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
public class ApiJsPayTradeServiceImpl extends IBaseServiceImpl<JsPayTrade> implements ApiJsPayTradeService {
    @Autowired
    ApiJsPaySunrateBankServiceImpl apiJsPaySunrateBankServiceimpl;

    @Override
    public ResponseMessage jsPayTradeAdd(JsPayTradeReq jsPayTradeReq) {
        JsPayTrade jsPayTrade = new JsPayTrade();
        BeanUtils.copyProperties(jsPayTradeReq,jsPayTrade);
        jsPayTrade.setId(IdUtil.simpleUUID());
        jsPayTrade.setCreateDts(new Date());
        super.insertSelective(jsPayTrade);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

//    public ResponseMessage jsPaySunrateBankTradeInAddEntry(JsPaySunrateBankTradeIn jsPaySunrateBankTradeIn){
//        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
//        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateBankTradeIn.getOrgCode());
//        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateBankTradeIn.getSubAcctNo());
//        JsPaySunrateBank jsPaySunrateBank = apiJsPaySunrateBankServiceimpl.selectOne(jsPaySunrateBankQuery);
//        jsPaySunrateBank.setCurrentAmt(jsPaySunrateBank.getCurrentAmt().add(jsPaySunrateBankTradeIn.getAvailableAmt()));
//        JsPayTrade jsPayTrade = new JsPayTrade();
//        jsPayTrade.setKycNaturalId(jsPaySunrateBank.getKycNaturalId());
//        jsPayTrade.setKycSunrateStoreId(jsPaySunrateBankTradeIn.getKycSunrateStoreId());
//        jsPayTrade.setInAcct(jsPaySunrateBankTradeIn.getBankCardNo());
//        jsPayTrade.setInAcctName(jsPaySunrateBank.getCusName());
//        jsPayTrade.setTradeNo(jsPaySunrateBankTradeIn.getTransinNoticeId());
//        jsPayTrade.setKycSunrateBankId(jsPaySunrateBank.getId());
//        jsPayTrade.setTradeType(TradeTypeEnum.TRADE_IN.getEnumCode());
//        jsPayTrade.setTradeSubType(TradeSubTypeEnum.SUB_TRADE_IN.getEnumCode());
//        jsPayTrade.setCurId(jsPaySunrateBankTradeIn.getTransinCur());
//        jsPayTrade.setTradeAmt(jsPaySunrateBankTradeIn.getAvailableAmt());//账户剩余金额
//        jsPayTrade.setOutAmt(new BigDecimal(0));
//        jsPayTrade.setInAmt(jsPaySunrateBankTradeIn.getAvailableAmt());
//        jsPayTrade.setUserAcctCurrAmt(jsPaySunrateBank.getCurrentAmt());
//        jsPayTrade.setUserAcctBorrowAmt(new BigDecimal(0));
//        jsPayTrade.setUserAcctAvailableAmt(new BigDecimal(0));
//        jsPayTrade.setUserAcctFrozenAmt(new BigDecimal(0));
//        jsPayTrade.setTradeDts(DateUtil.parse(jsPaySunrateBankTradeIn.getSysTxnDate()));
//        super.insertSelective(jsPayTrade);
//        apiJsPaySunrateBankServiceimpl.updateByPrimaryKeySelective(jsPaySunrateBank);
//        return ResultUtil.success(ResultEnum.SUCCESS);
//    }
}
