package com.js.pay.service.impl;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.BeneficiaryTypeEnum;
import com.js.common.enums.LockPriceTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import com.js.dal.dao.mapper.JsPaySunrateTradeLockPriceMapper;
import com.js.dal.dao.mapper.JsPaySunrateTradeQueryPriceMapper;
import com.js.dal.dao.mapper.KycSunrateStoreMapper;
import com.js.dal.dao.model.JsPaySunrateBank;
import com.js.dal.dao.model.JsPaySunrateTradeLockPrice;
import com.js.dal.dao.model.JsPaySunrateTradeQueryPrice;
import com.js.dal.dao.model.KycSunrateStore;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Description: 锁汇成交接口具体实现
 * @Author: liuh
 * @Create: 2019-6-11
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySunrateTradeLockPriceServiceImpl extends IBaseServiceImpl<JsPaySunrateTradeLockPrice> implements ApiJsPaySunrateTradeLockPriceService {
    @Autowired
    KycSunrateService kycSunrateService;
    @Value("${sunrate.requestno.prefix}")
    private String requestNoPrefix;
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;
    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;
    @Autowired
    JsPaySunrateTradeLockPriceMapper jsPaySunrateTradeLockPriceMapper;
    @Autowired
    ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Autowired
    JsPaySunrateTradeQueryPriceMapper jsPaySunrateTradeQueryPriceMapper;
    @Autowired
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;

    @Override
    public ResponseMessage queryPriceTradeOrder(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq) {
        log.info("发送询价锁汇请求交易开始：{}",JSON.toJSONString(jsPaySunrateBankTradeInReq));
        JsPaySunrateTradeQueryPriceVo jsPaySunrateTradeQueryPriceVo = xhQueryPrice(jsPaySunrateBankTradeInReq.getTxnAmt(),jsPaySunrateBankTradeInReq.getTransinCur(), jsPaySunrateBankTradeInReq.getOrgCode());
        if(null ==jsPaySunrateTradeQueryPriceVo){
            log.error("询价失败");
            return ResultUtil.error(ResultEnum.QUERY_PRICE_FAILURE);
        }
        JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq = ConvertToJsPaySunrateQueryPriceTradeCreateReq(jsPaySunrateBankTradeInReq,jsPaySunrateTradeQueryPriceVo);
        ResponseMessage responseMessage = sendQueryPriceTradeOrderToSunrate(jsPaySunrateQueryPriceTradeCreateReq);
        log.info("发送询价锁汇请求交易结束，结果{}，信息{}",responseMessage.getCode(),responseMessage.getMsg());
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice;
        log.info("保存询价锁汇请求信息-开始");
        if(responseMessage.isSuccess()){
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            jsPaySunrateTradeLockPrice = jsonObject.toJavaObject(JsPaySunrateTradeLockPrice.class);
        }else{
            jsPaySunrateTradeLockPrice = new JsPaySunrateTradeLockPrice();
            jsPaySunrateTradeLockPrice.setTxnStatus(CommonConstant.SEND_SUNRATE_TXN_STATUS);
            jsPaySunrateTradeLockPrice.setRemark(responseMessage.getMsg());
        }
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        kycSunrateStoreQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            log.error("未查询到寻汇店铺信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        JsPaySunrateBank jsPaySunrateBank = jsPaySunrateBankMapper.selectOne(jsPaySunrateBankQuery);
        if(null == jsPaySunrateBank){
            log.error("未查询到寻汇虚拟银行账户信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        BeanUtils.copyProperties(jsPaySunrateQueryPriceTradeCreateReq,jsPaySunrateTradeLockPrice);
        jsPaySunrateTradeLockPrice.setId(IdUtil.simpleUUID());
        jsPaySunrateTradeLockPrice.setKycSunrateBankId(jsPaySunrateBank.getId());
        jsPaySunrateTradeLockPrice.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateTradeLockPrice.setKycSunrateStoreId(kycSunrateStore.getId());//寻汇店铺表主键ID
        jsPaySunrateTradeLockPrice.setRequestType(LockPriceTypeEnum.TRADE_MARKET_ORDER);
        jsPaySunrateTradeLockPrice.setTradeType(TradeSubTypeEnum.REPAYMENT);
        jsPaySunrateTradeLockPrice.setCreateId("jstransfer");
        jsPaySunrateTradeLockPrice.setCreateName("源奉方");
        int insertCount = super.insertSelective(jsPaySunrateTradeLockPrice);
        log.info("保存询价锁汇请求信息-结束:{}", insertCount);

        JsPaySunrateTradeQueryPrice jsPaySunrateTradeQueryPrice = new JsPaySunrateTradeQueryPrice();
        BeanUtils.copyProperties(jsPaySunrateTradeQueryPriceVo,jsPaySunrateTradeQueryPrice);
        jsPaySunrateTradeQueryPrice.setId(IdUtil.simpleUUID());
        jsPaySunrateTradeQueryPrice.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateTradeQueryPrice.setKycSunrateBankId(jsPaySunrateBank.getId());
        jsPaySunrateTradeQueryPrice.setKycSunrateStoreId(kycSunrateStore.getId());
        jsPaySunrateTradeQueryPrice.setJsRemark("应用在询价锁汇接口的询价请求报文");
        jsPaySunrateTradeQueryPriceMapper.insert(jsPaySunrateTradeQueryPrice);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private JsPaySunrateTradeQueryPriceVo xhQueryPrice(BigDecimal txnAmt,String transinCur, String orgCode){
        SunrateTradePriceReq sunrateTradePriceReq = new SunrateTradePriceReq();
        sunrateTradePriceReq.setOrgCode(orgCode);
        sunrateTradePriceReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNH);
        sunrateTradePriceReq.setSellCur(transinCur);
        sunrateTradePriceReq.setTxnMode(CommonConstant.TXN_MODE_BUY);
        sunrateTradePriceReq.setTxnAmt(txnAmt);
        sunrateTradePriceReq.setBrowserIP(NetUtil.getLocalhostStr());
        ResponseMessage responseMessage = apiSunrateTradePriceService.xhTradeQueryPrice(sunrateTradePriceReq);
        log.info("寻汇-询价结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        if(responseMessage.isSuccess()){
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            return jsonObject.toJavaObject(JsPaySunrateTradeQueryPriceVo.class);
        }
        log.info("询价结果未成功，返回空值");
        return null;
    }

    @Override
    public ResponseMessage withdrawAndRefundList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO) {
        jsTradeListReq.setKycNaturalId(kycNaturalVO.getId());
        PageHelper.startPage(jsTradeListReq.getStartPage(),jsTradeListReq.getPageSize());
        List<JsTradeListVO> resultList = jsPaySunrateTradeLockPriceMapper.selectTradeShowList(jsTradeListReq);
        PageInfo<JsTradeListVO> jsTradeListVOPageInfo = new PageInfo<>(resultList);
        return ResultUtil.success(jsTradeListVOPageInfo);
    }

    @Override
    public ResponseMessage withdrawAndRefundDetail(String tradeId) {
        return null;
    }

    @Override
    public JsPaySunrateTradeLockPriceVO findTradeLockInfo(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq) {
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPriceQuery = new JsPaySunrateTradeLockPrice();
        jsPaySunrateTradeLockPriceQuery.setTxnNo(jsPaySunrateBankTradeOutReq.getTxnNo());
        jsPaySunrateTradeLockPriceQuery.setLockNo(jsPaySunrateBankTradeOutReq.getLockNo());
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice = iBaseMapper.selectOne(jsPaySunrateTradeLockPriceQuery);
        if(null == jsPaySunrateTradeLockPrice){
            log.error("未查询到锁汇信息");
            return null;
        }
        JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO = new JsPaySunrateTradeLockPriceVO();
        BeanUtils.copyProperties(jsPaySunrateTradeLockPrice,jsPaySunrateTradeLockPriceVO);
        return jsPaySunrateTradeLockPriceVO;
    }

    /**
     * 发送询价锁汇请求到寻汇
     */
    private ResponseMessage sendQueryPriceTradeOrderToSunrate(JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq){
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(jsPaySunrateQueryPriceTradeCreateReq));
        Map<String,String> mapParams = (Map)jsonObjectReq;
        return kycSunrateService.sendInfoToXh(NetUtil.getLocalhostStr(),"trade.create","trade/create/",mapParams);
    }

    private JsPaySunrateQueryPriceTradeCreateReq ConvertToJsPaySunrateQueryPriceTradeCreateReq(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq, JsPaySunrateTradeQueryPriceVo jsPaySunrateTradeQueryPriceVo){
        JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq = new JsPaySunrateQueryPriceTradeCreateReq();
        jsPaySunrateQueryPriceTradeCreateReq.setLockNo(requestNoPrefix + kycSunrateService.getReqNo());
        jsPaySunrateQueryPriceTradeCreateReq.setQueryNo(jsPaySunrateTradeQueryPriceVo.getQueryNo());
        jsPaySunrateQueryPriceTradeCreateReq.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        jsPaySunrateQueryPriceTradeCreateReq.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        jsPaySunrateQueryPriceTradeCreateReq.setSellAmt(jsPaySunrateTradeQueryPriceVo.getSellAmt());
        jsPaySunrateQueryPriceTradeCreateReq.setSellCur(jsPaySunrateTradeQueryPriceVo.getSellCur());
        jsPaySunrateQueryPriceTradeCreateReq.setBuyAmt(jsPaySunrateTradeQueryPriceVo.getBuyAmt());
        jsPaySunrateQueryPriceTradeCreateReq.setBuyCur(jsPaySunrateTradeQueryPriceVo.getBuyCur());
        jsPaySunrateQueryPriceTradeCreateReq.setFeeAmt(jsPaySunrateTradeQueryPriceVo.getFeeAmt());
        jsPaySunrateQueryPriceTradeCreateReq.setFeeCur(jsPaySunrateTradeQueryPriceVo.getFeeCur());
        jsPaySunrateQueryPriceTradeCreateReq.setPayAmt(jsPaySunrateTradeQueryPriceVo.getPayAmt());//支付总金额
        jsPaySunrateQueryPriceTradeCreateReq.setTxnMode(jsPaySunrateTradeQueryPriceVo.getTxnMode());
        jsPaySunrateQueryPriceTradeCreateReq.setQueryRate(jsPaySunrateTradeQueryPriceVo.getQueryRate());//询价汇率

        List<KycSunrateBeneficiaryVO> kycSunrateBeneficiaryVOList = apiSunrateBeneficiaryService.beneficiaryListByOrgCode(jsPaySunrateBankTradeInReq.getOrgCode(), BeneficiaryTypeEnum.PLATEFORM_SELF);
        if(CollectionUtils.isNotEmpty(kycSunrateBeneficiaryVOList)){
            KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO = kycSunrateBeneficiaryVOList.get(0);
            jsPaySunrateQueryPriceTradeCreateReq.setBeneficiaryId(kycSunrateBeneficiaryVO.getBeneficiaryId());
        }
        jsPaySunrateQueryPriceTradeCreateReq.setRemark("询价锁汇");
        return jsPaySunrateQueryPriceTradeCreateReq;
    }

    @Override
    public ResponseMessage tradeMarketOrder(JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq,String kycNaturalId,String kycSunrateStoreId,String kycSunrateBankId) {
        log.info("发送市价锁汇请求交易开始：{}",JSON.toJSONString(jsPaySunrateTradeMarketOrderReq));
        ResponseMessage responseMessage = sendTradeMarketOrderToSunrate(jsPaySunrateTradeMarketOrderReq);
        log.info("发送市价锁汇请求交易结束，结果{}，信息{}",responseMessage.getCode(),responseMessage.getMsg());
        JsPaySunrateTradeLockPrice jsPaySunrateTradeLockPrice;
        if(responseMessage.isSuccess()){
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            jsPaySunrateTradeLockPrice = jsonObject.toJavaObject(JsPaySunrateTradeLockPrice.class);
        }else{
            jsPaySunrateTradeLockPrice = new JsPaySunrateTradeLockPrice();
            jsPaySunrateTradeLockPrice.setTxnStatus(CommonConstant.SEND_SUNRATE_TXN_STATUS);
        }
        BeanUtils.copyProperties(jsPaySunrateTradeMarketOrderReq,jsPaySunrateTradeLockPrice);
        jsPaySunrateTradeLockPrice.setId(IdUtil.simpleUUID());
        jsPaySunrateTradeLockPrice.setCreateId("jstransfer");
        jsPaySunrateTradeLockPrice.setCreateName("源奉方");
        jsPaySunrateTradeLockPrice.setTradeType(TradeSubTypeEnum.WITHDRAW);
        jsPaySunrateTradeLockPrice.setRequestType(LockPriceTypeEnum.TRADE_MARKET_ORDER);
        jsPaySunrateTradeLockPrice.setKycNaturalId(kycNaturalId);
        jsPaySunrateTradeLockPrice.setKycSunrateBankId(kycSunrateBankId);
        jsPaySunrateTradeLockPrice.setKycSunrateStoreId(kycSunrateStoreId);
        int insertCount = super.insertSelective(jsPaySunrateTradeLockPrice);
        log.info("市价锁汇插入数据条数：{}",insertCount);
        return responseMessage.isSuccess() ? ResultUtil.success(ResultEnum.SUCCESS) : responseMessage;
    }

    /**
     * 发送市价锁汇请求到寻汇
     */
    private ResponseMessage sendTradeMarketOrderToSunrate(JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq){
        JSONObject jsonObjectReq = JSON.parseObject(JSON.toJSONString(jsPaySunrateTradeMarketOrderReq));
        jsonObjectReq.remove("tradeSubType");
        jsonObjectReq.remove("kycBankId");
        jsonObjectReq.remove("bankNo");
        Map<String,String> mapParams = (Map)jsonObjectReq;
        return kycSunrateService.sendInfoToXh(NetUtil.getLocalhostStr(),"trade.marketOrder","trade/marketOrder/",mapParams);
    }
}
