package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.js.api.jspay.service.ApiJsPaySunrateBankTradeOutService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPaySunrateBankTradeOutReq;
import com.js.common.model.vo.JsPaySunrateTradeLockPriceVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.*;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: 寻汇通知合作方出账交互具体实现
 * @Author: liuh
 * @Create: 2019-06-13
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySunrateBankTradeOutServiceImpl extends IBaseServiceImpl<JsPaySunrateBankTradeOut> implements ApiJsPaySunrateBankTradeOutService {
    @Autowired
    ApiJsPaySunrateTradeLockPriceServiceImpl apiJsPaySunrateTradeLockPriceServiceimpl;

    @Override
    public ResponseMessage bankTradeOutNotice(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq, JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO) {
        JsPaySunrateBankTradeOut jsPaySunrateBankTradeOut = new JsPaySunrateBankTradeOut();
        BeanUtils.copyProperties(jsPaySunrateBankTradeOutReq,jsPaySunrateBankTradeOut);
        jsPaySunrateBankTradeOut.setId(IdUtil.simpleUUID());
        jsPaySunrateBankTradeOut.setKycSunrateBankId(jsPaySunrateTradeLockPriceVO.getKycSunrateBankId());
        jsPaySunrateBankTradeOut.setKycNaturalId(jsPaySunrateTradeLockPriceVO.getKycNaturalId());
        jsPaySunrateBankTradeOut.setKycSunrateStoreId(jsPaySunrateTradeLockPriceVO.getKycSunrateStoreId());//寻汇店铺表主键ID
        jsPaySunrateBankTradeOut.setCreateName("寻汇");
        jsPaySunrateBankTradeOut.setCreateId(jsPaySunrateTradeLockPriceVO.getKycNaturalId());
        jsPaySunrateBankTradeOut.setJsRemark("寻汇出账通知");
        super.insertSelective(jsPaySunrateBankTradeOut);
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }
}
