package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.api.jspay.service.ApiJsPaySunrateBankTradeInService;
import com.js.api.jspay.service.ApiJsPayTradeService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.JsTradeListVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import com.js.dal.dao.mapper.JsPaySunrateBankTradeInMapper;
import com.js.dal.dao.mapper.KycSunrateStoreMapper;
import com.js.dal.dao.model.JsPaySunrateBank;
import com.js.dal.dao.model.JsPaySunrateBankTradeIn;
import com.js.dal.dao.model.KycSunrateStore;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @Description: 寻汇通知合作方交互具体实现
 * @Author: liuh
 * @Create: 2019-06-3
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
@Slf4j
public class ApiJsPaySunrateBankTradeInServiceImpl extends IBaseServiceImpl<JsPaySunrateBankTradeIn> implements ApiJsPaySunrateBankTradeInService {
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;
    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;
    @Autowired
    ApiJsPayTradeService apiJsPayTradeService;
    @Autowired
    ApiJsPayTradeServiceImpl apiJsPayTradeServiceimpl;
    @Autowired
    JsPaySunrateBankTradeInMapper jsPaySunrateBankTradeInMapper;

    @Override
    public ResponseMessage bankTradeInNotice(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq) {
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        kycSunrateStoreQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            log.error("未查询到寻汇店铺信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        JsPaySunrateBank jsPaySunrateBank = jsPaySunrateBankMapper.selectOne(jsPaySunrateBankQuery);
        if(null == jsPaySunrateBank){
            log.error("未查询到寻汇虚拟银行账户信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        JsPaySunrateBankTradeIn jsPaySunrateBankTradeIn = new JsPaySunrateBankTradeIn();
        BeanUtils.copyProperties(jsPaySunrateBankTradeInReq,jsPaySunrateBankTradeIn);
        jsPaySunrateBankTradeIn.setId(IdUtil.simpleUUID());
        jsPaySunrateBankTradeIn.setKycSunrateBankId(jsPaySunrateBank.getId());
        jsPaySunrateBankTradeIn.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateBankTradeIn.setKycSunrateStoreId(kycSunrateStore.getId());//寻汇店铺表主键ID
        jsPaySunrateBankTradeIn.setCreateName("寻汇推送");
        jsPaySunrateBankTradeIn.setCreateId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateBankTradeIn.setJsRemark("寻汇入账通知");
        super.insertSelective(jsPaySunrateBankTradeIn);
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    @Override
    public ResponseMessage tradeInList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO) {
        jsTradeListReq.setKycNaturalId(kycNaturalVO.getId());
        PageHelper.startPage(jsTradeListReq.getStartPage(),jsTradeListReq.getPageSize());
        log.info("查询入账列表开始:{}", JSON.toJSONString(jsTradeListReq));
        List<JsTradeListVO> resultList = jsPaySunrateBankTradeInMapper.selectTradeShowList(jsTradeListReq);
        PageInfo<JsTradeListVO> jsTradeListVOPageInfo = new PageInfo<>(resultList);
        return ResultUtil.success(jsTradeListVOPageInfo);
    }

    @Override
    public ResponseMessage tradeInDetail(String tradeInId) {
        return ResultUtil.success(jsPaySunrateBankTradeInMapper.selectTradeShowDetail(tradeInId));
    }
}
