package com.js.pay.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiJsPaySunrateBankService;
import com.js.api.jspay.service.ApiJsPaySunrateTradeLockPriceService;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.enums.BeneficiaryTypeEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.ApplyWithdrawReq;
import com.js.common.model.req.JsPaySunrateBankReq;
import com.js.common.model.req.JsPaySunrateBankTradeInReq;
import com.js.common.model.req.JsPaySunrateTradeMarketOrderReq;
import com.js.common.model.vo.JsPaySunrateBankVO;
import com.js.common.model.vo.KycBankVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateBeneficiaryVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.JsPaySunrateBankMapper;
import com.js.dal.dao.mapper.KycSunrateStoreMapper;
import com.js.dal.dao.model.JsPaySunrateBank;
import com.js.dal.dao.model.JsPaySunrateBankTradeIn;
import com.js.dal.dao.model.KycSunrateStore;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import javax.xml.transform.Result;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 寻汇收款虚拟子账户表操作接口具体实现
 * @Author: liuh
 * @Create: 2019-06-3
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ApiJsPaySunrateBankServiceImpl extends IBaseServiceImpl<JsPaySunrateBank> implements ApiJsPaySunrateBankService {
    @Autowired
    KycSunrateStoreMapper kycSunrateStoreMapper;
    @Autowired
    ApiJsPaySunrateBankTradeInServiceImpl apiJsPaySunrateBankTradeInServiceimpl;
    @Autowired
    JsPaySunrateBankMapper jsPaySunrateBankMapper;
    @Autowired
    ApiJsPaySunrateTradeLockPriceService apiJsPaySunrateTradeLockPriceService;
    @Autowired
    KycSunrateService kycSunrateService;
    @Value("${sunrate.requestno.prefix}")
    private String requestNoPrefix;
    @Autowired
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;

    @Override
    public ResponseMessage virtualNotice(JsPaySunrateBankReq jsPaySunrateBankReq){
        KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
        kycSunrateStoreQuery.setOrgCode(jsPaySunrateBankReq.getOrgCode());
        kycSunrateStoreQuery.setSubAcctNo(jsPaySunrateBankReq.getSubAcctNo());
        KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
        if(null == kycSunrateStore){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),ResultEnum.ERROR.getMsg());
        }
        JsPaySunrateBank jsPaySunrateBank = new JsPaySunrateBank();
        BeanUtils.copyProperties(jsPaySunrateBankReq,jsPaySunrateBank);
        jsPaySunrateBank.setCusName(jsPaySunrateBankReq.getCustName());
        jsPaySunrateBank.setId(IdUtil.simpleUUID());
        jsPaySunrateBank.setKycNaturalId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateBank.setCreateName("寻汇推送");
        jsPaySunrateBank.setCreateId(kycSunrateStore.getKycNaturalId());
        jsPaySunrateBank.setJsRemark("寻汇虚拟子账户通知");
        super.insertSelective(jsPaySunrateBank);
        return ResultUtil.success(ResultEnum.SUCCESS.getCode(), ResultEnum.SUCCESS.getMsg());
    }

    @Override
    public ResponseMessage updateVirtualAmt(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq) {
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateBankTradeInReq.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateBankTradeInReq.getSubAcctNo());
        jsPaySunrateBankQuery.setBankCardNo(jsPaySunrateBankTradeInReq.getBankCardNo());
        JsPaySunrateBank jsPaySunrateBank = iBaseMapper.selectOne(jsPaySunrateBankQuery);
        jsPaySunrateBank.setCurrentAmt(jsPaySunrateBank.getCurrentAmt().add(jsPaySunrateBankTradeInReq.getTxnAmt()));
        int updateCount = iBaseMapper.updateByPrimaryKeySelective(jsPaySunrateBank);
        log.info("更新虚拟账户余额完成，更新条数：{}",updateCount);
        if(jsPaySunrateBankTradeInReq.isUpdateTradeInFlag()){
            JsPaySunrateBankTradeIn jsPaySunrateBankTradeInQuery = new JsPaySunrateBankTradeIn();
            jsPaySunrateBankTradeInQuery.setTransinNoticeId(jsPaySunrateBankTradeInReq.getTransinNoticeId());
            JsPaySunrateBankTradeIn jsPaySunrateBankTradeIn = apiJsPaySunrateBankTradeInServiceimpl.getiBaseMapper().selectOne(jsPaySunrateBankTradeInQuery);
            jsPaySunrateBankTradeIn.setProcessStatus(jsPaySunrateBankTradeInReq.getProcessStatusEnum());
            jsPaySunrateBankTradeIn.setAvailableBalance(jsPaySunrateBank.getCurrentAmt());//账户可用余额
            int updateStatus = apiJsPaySunrateBankTradeInServiceimpl.getiBaseMapper().updateByPrimaryKeySelective(jsPaySunrateBankTradeIn);
            log.info("更新入账状态完成，transinNoticeId{}，更新条数：{}",jsPaySunrateBankTradeInReq.getTransinNoticeId(),updateStatus);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public JsPaySunrateBankVO findSunrateBankInfo(JsPaySunrateBankReq jsPaySunrateBankReq, KycNaturalVO kycNaturalVO) {
        JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
        jsPaySunrateBankQuery.setKycNaturalId(kycNaturalVO.getId());
        jsPaySunrateBankQuery.setOrgCode(jsPaySunrateBankReq.getOrgCode());
        jsPaySunrateBankQuery.setSubAcctNo(jsPaySunrateBankReq.getSubAcctNo());
        JsPaySunrateBank jsPaySunrateBank = iBaseMapper.selectOne(jsPaySunrateBankQuery);
        if(null == jsPaySunrateBank){
            log.info("未查询到虚拟账户信息");
            return null;
        }
        JsPaySunrateBankVO jsPaySunrateBankVO = new JsPaySunrateBankVO();
        BeanUtils.copyProperties(jsPaySunrateBank,jsPaySunrateBankVO);
        return jsPaySunrateBankVO;
    }

    @Override
    public ResponseMessage selCanWithdrawAcctList(SiteEnum siteEnum, KycNaturalVO kycNaturalVO) {
        log.info("查询可提现账户信息开始:{}",siteEnum);
        Map<String,String> params = new HashMap<>();
        params.put("kycNaturalId",kycNaturalVO.getId());
        params.put("curId",siteEnum.getCurrency());
        List<Map<String,Object>> canWithdrawStoreList = jsPaySunrateBankMapper.findCanWithdrawStoreList(params);
        canWithdrawStoreList.stream().forEach(map -> {
            map.put("withdrawAmt",map.get("currentAmt"));
            map.put("currencySymbol",SiteEnum.getByCurrency(map.get("curId").toString()).getCurrencySymbol());
        });
        log.info("查询可提现账户信息结束:条数{}", CollectionUtils.isEmpty(canWithdrawStoreList) ? 0 : canWithdrawStoreList.size());
        return ResultUtil.success(canWithdrawStoreList);
    }

    @Override
    public ResponseMessage applyWithdraw(ApplyWithdrawReq applyWithdrawReq, KycNaturalVO kycNaturalVO, KycBankVO kycBankVO) {
        log.info("店铺申请提现-开始:{}", JSON.toJSONString(applyWithdrawReq));
        try {
            KycSunrateStore kycSunrateStoreQuery = new KycSunrateStore();
            kycSunrateStoreQuery.setKycStoreId(applyWithdrawReq.getStoreId());
            kycSunrateStoreQuery.setKycNaturalId(kycNaturalVO.getId());
            KycSunrateStore kycSunrateStore = kycSunrateStoreMapper.selectOne(kycSunrateStoreQuery);
            if (null == kycSunrateStore) {
                log.info("未查询到寻汇店铺信息:{}", JSON.toJSONString(kycSunrateStoreQuery));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            JsPaySunrateBank jsPaySunrateBankQuery = new JsPaySunrateBank();
            jsPaySunrateBankQuery.setKycNaturalId(kycNaturalVO.getId());
            jsPaySunrateBankQuery.setOrgCode(kycSunrateStore.getOrgCode());
            jsPaySunrateBankQuery.setSubAcctNo(kycSunrateStore.getSubAcctNo());
            JsPaySunrateBank jsPaySunrateBank = jsPaySunrateBankMapper.selectOne(jsPaySunrateBankQuery);
            if (null == jsPaySunrateBank) {
                log.info("未查询到寻汇虚拟账户信息:{}", JSON.toJSONString(jsPaySunrateBankQuery));
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            if (applyWithdrawReq.getWithdrawAmt().compareTo(jsPaySunrateBank.getCurrentAmt()) > 0) {
                log.error("提现金额超出可用余额");
                return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
            }
            jsPaySunrateBank.setCurrentAmt(jsPaySunrateBank.getCurrentAmt().subtract(applyWithdrawReq.getWithdrawAmt()));
            jsPaySunrateBank.setFreezedAmt(applyWithdrawReq.getWithdrawAmt());
            int updateJsSunrateBankCount = jsPaySunrateBankMapper.updateByPrimaryKeySelective(jsPaySunrateBank);
            log.info("更新余额结果:{}", updateJsSunrateBankCount);

            List<KycSunrateBeneficiaryVO> kycSunrateBeneficiaryVOS = apiSunrateBeneficiaryService.beneficiaryListByOrgCode(jsPaySunrateBank.getOrgCode(), BeneficiaryTypeEnum.PLATEFORM_SELF);
            if(CollectionUtils.isEmpty(kycSunrateBeneficiaryVOS)){
                log.error("查询受益人信息不存在，orgCode:{}",jsPaySunrateBank.getOrgCode());
                return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
            }
            JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = ConvertToJsPaySunrateTradeMarketOrderReq(applyWithdrawReq, jsPaySunrateBank, kycBankVO,kycSunrateBeneficiaryVOS.get(0));
            ResponseMessage responseMessage = apiJsPaySunrateTradeLockPriceService.tradeMarketOrder(jsPaySunrateTradeMarketOrderReq,kycNaturalVO.getId(),kycSunrateStore.getId(),jsPaySunrateBank.getId());
            log.info("请求寻汇市价锁汇接口返回结果：{},{}", responseMessage.isSuccess(), responseMessage.getMsg());
            if(!responseMessage.isSuccess()){
                return responseMessage;
            }
        }catch (Exception ex){
            log.error("提现交易失败storeId:{},bankId:{}",applyWithdrawReq.getStoreId(),applyWithdrawReq.getBankId());
            log.error("提现交易失败", ex);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    private JsPaySunrateTradeMarketOrderReq ConvertToJsPaySunrateTradeMarketOrderReq(ApplyWithdrawReq applyWithdrawReq,JsPaySunrateBank jsPaySunrateBank, KycBankVO kycBankVO,KycSunrateBeneficiaryVO kycSunrateBeneficiaryVO){
        JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq = new JsPaySunrateTradeMarketOrderReq();
        jsPaySunrateTradeMarketOrderReq.setLockNo(requestNoPrefix + kycSunrateService.getReqNo());
        jsPaySunrateTradeMarketOrderReq.setOrgCode(jsPaySunrateBank.getOrgCode());
        jsPaySunrateTradeMarketOrderReq.setSubAcctNo(jsPaySunrateBank.getSubAcctNo());
        //如果买入币种为人民币时转换币种为离岸人民币CNH，否则使用原记录币种
        jsPaySunrateTradeMarketOrderReq.setBuyCur(CommonConstant.TRADE_CURRENCY_CNY.equals(kycBankVO.getCurrencyCode()) ? CommonConstant.TRADE_CURRENCY_CNH : kycBankVO.getCurrencyCode());
        jsPaySunrateTradeMarketOrderReq.setSellCur(jsPaySunrateBank.getCurId());
        jsPaySunrateTradeMarketOrderReq.setTxnAmt(applyWithdrawReq.getWithdrawAmt());
        jsPaySunrateTradeMarketOrderReq.setValueDate(DateUtil.format(new Date(),"yyyy-MM-dd"));
        jsPaySunrateTradeMarketOrderReq.setTradeSubType(TradeSubTypeEnum.WITHDRAW);
        jsPaySunrateTradeMarketOrderReq.setBeneficiaryId(kycSunrateBeneficiaryVO.getBeneficiaryId());//受益人编号
        jsPaySunrateTradeMarketOrderReq.setKycBankId(applyWithdrawReq.getBankId());
        jsPaySunrateTradeMarketOrderReq.setBankNo(applyWithdrawReq.getAccountNo());
        return jsPaySunrateTradeMarketOrderReq;
    }
}
