package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsPayStationOrganInfoService;
import com.js.common.constant.Constant;
import com.js.dal.dao.mapper.JsPayStationOrganInfoMapper;
import com.js.dal.dao.model.JsPayStationOrganInfo;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        retries = 0
)
@Slf4j
public class ApiJsPayStationOrganInfoServiceImpl extends IBaseServiceImpl<JsPayStationOrganInfo> implements ApiJsPayStationOrganInfoService {
    @Autowired
    JsPayStationOrganInfoMapper jsPayStationOrganInfoMapper;

    @Override
    public String queryVatStationStatus(String taxStationId) {
        return jsPayStationOrganInfoMapper.queryVatStationStatus(taxStationId);
    }
}
