package com.js.pay.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.ApiJsPayExchangeOpenAcctService;
import com.js.common.constant.CommonConstant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.JsPayExchangeOpenAcct;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.KycSunrateService;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;

/**
 * @Description: 外汇渠道开户请求响应表操作具体实现
 * @Author: liuh
 * @Create: 2019-06-05
 **/
@Service
public class ApiJsPayExchangeOpenAcctServiceImpl extends IBaseServiceImpl<JsPayExchangeOpenAcct> implements ApiJsPayExchangeOpenAcctService {
    @Autowired
    KycSunrateService kycSunrateService;

    @Override
    public ResponseMessage jsPayExchangeOpenAcctAdd(Map<String,String> mapParams,ResponseMessage responseMessage) {
        JsPayExchangeOpenAcct jsPayExchangeOpenAcct = new JsPayExchangeOpenAcct();
        jsPayExchangeOpenAcct.setId(IdUtil.simpleUUID());
        jsPayExchangeOpenAcct.setReqNo(kycSunrateService.getReqNo());
        jsPayExchangeOpenAcct.setReqMsg(JSON.toJSONString(mapParams));
        jsPayExchangeOpenAcct.setRespMsg(JSON.toJSONString(responseMessage));
        jsPayExchangeOpenAcct.setStatus(responseMessage.isSuccess() ? "1" : "0");
        jsPayExchangeOpenAcct.setCreateId(CommonConstant.SUNRATE_CREATE_ID);
        jsPayExchangeOpenAcct.setCreateName(CommonConstant.SUNRATE_CREATE_NAME);
        jsPayExchangeOpenAcct.setCreateDts(new Date());
        jsPayExchangeOpenAcct.setJsRemark("请求寻汇注册用户接口请求与响应报文");
        super.insertSelective(jsPayExchangeOpenAcct);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }
}
