package com.js.pay.service.impl;

import com.js.api.jspay.service.ApiJsKycChargeService;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsKycChargeReq;
import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.vo.JsKycChargeVO;
import com.js.dal.dao.model.JsKycCharge;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;

/**
 * @Description: 用户汇率操作接口具体实现
 * @Author: liuh
 * @Create: 2019-06-23
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}",
        timeout = 60000
)
public class ApiJsKycChargeServiceImpl extends IBaseServiceImpl<JsKycCharge> implements ApiJsKycChargeService {

    @Override
    public JsKycChargeVO findKycChargeInfo(JsKycChargeReq jsKycChargeReq) {
        JsKycCharge jsKycChargeQuery = new JsKycCharge();
        BeanUtils.copyProperties(jsKycChargeReq,jsKycChargeQuery);
        JsKycCharge jsKycCharge = iBaseMapper.selectOne(jsKycChargeQuery);
        if(null == jsKycCharge){
            return null;
        }
        JsKycChargeVO jsKycChargeVO = new JsKycChargeVO();
        BeanUtils.copyProperties(jsKycCharge,jsKycChargeVO);
        return jsKycChargeVO;
    }
}
