package com.js.pay.service.impl;

import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChPwdReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.model.KycPassword;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

/**
 * @ClassName: APIKycPassWordServiceImpl
 * @Description: 密码对象serviceImpl
 * @Author: yjzhao
 * @Create: 2019-05-22  15:18
 **/
@Service
public class APIKycPassWordServiceImpl extends IBaseServiceImpl<KycPassword> {

    /**
     * @Author yjzhao
     * @Description 更改密码
     * @Date 2019/5/23 16:02
     * @Param [chPwdReq]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    public ResponseMessage changePwd(ChPwdReq chPwdReq) {
        Example example = new Example(KycPassword.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("kycNaturalId", chPwdReq.getKycNaturalId());
        criteria.andEqualTo("delFlag", false);

        KycPassword kycPassword = new KycPassword();
        kycPassword.setPasswordLogin(chPwdReq.getNewPwd());
        int i = iBaseMapper.updateByExampleSelective(kycPassword, example);
        if (i > 0) {
            return ResultUtil.success(ResultEnum.CHANGE_PWD_SUCCESS);
        }
        return ResultUtil.success(ResultEnum.CHANGE_PWD_ERROR);
    }
}
