package com.js.pay.service.chinapnr.impl;

import com.js.api.jspay.service.chinapnr.ChinaPNRPaySubstituteService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChinaPNRSubstituteDetails;
import com.js.common.model.req.ChinaPNRSubstituteQueryReq;
import com.js.common.model.req.ChinaPNRSubstituteReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.ChinaPNRBatchDetailedPayMapper;
import com.js.dal.dao.mapper.ChinaPNRBatchPayMapper;
import com.js.dal.dao.model.ChinaPNRBatchDetailedPay;
import com.js.dal.dao.model.ChinaPNRBatchPay;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.pay.ChinaPNRNewSubstitute;
import com.js.pay.service.chinapnr.example.pay.ChinaPNROldSubstitute;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * @Description:汇付天下业务代发
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ChinaPNRPaySubstituteServiceImpl implements ChinaPNRPaySubstituteService {


    @Autowired
    private ChinaPNRBatchPayMapper chinaPNRBatchPayMapper;

    @Autowired
    private ChinaPNRBatchDetailedPayMapper chinaPNRBatchDetailedPayMapper;

    /**
     * 客户提现
     * @param chinaPNRSubstituteReq
     * @return
     */
    @Override
    public ResponseMessage newSubstituteTrade(ChinaPNRSubstituteReq chinaPNRSubstituteReq) {
        log.info("客户代发客户提现业务执行 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        batchChinaPayInsert(chinaPNRSubstituteReq, ChinaPNRCommons.getPropertiesParam("CHINA_PNR_NEW_RESULT_URL"));
        //执行汇付代发功能
        ChinaPNRNewSubstitute pay = new ChinaPNRNewSubstitute();
        Map<String,String> resMap = pay.substitute(chinaPNRSubstituteReq);
        boolean falg = resMap.get("code").equals(ResultEnum.CHINA_PNR_SUCCESS.getCode());

        updateBatchChinaPNRPay(resMap,falg,chinaPNRSubstituteReq.getBatchNo());
        log.info("客户代发提现业务执行完毕 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        if(falg){
            return ResultUtil.success(ResultEnum.CHINA_PNR_SUCCESS);
        }else{
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
    }

    /**
     * 客户还款，还款服务费,汇差 ，提现服务费交易
     * @param chinaPNRSubstituteReq
     * @return
     */
    @Override
    public ResponseMessage oldSubstituteTrade(ChinaPNRSubstituteReq chinaPNRSubstituteReq) {

        log.info("客户代发业务执行 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        batchChinaPayInsert(chinaPNRSubstituteReq, ChinaPNRCommons.getPropertiesParam("CHINA_PNR_OLD_RESULT_URL"));
        //执行汇付代发功能
        ChinaPNROldSubstitute pay = new ChinaPNROldSubstitute();
        Map<String,String> resMap = pay.substitute(chinaPNRSubstituteReq);
        boolean falg = resMap.get("code").equals(ResultEnum.CHINA_PNR_SUCCESS.getCode());

        updateBatchChinaPNRPay(resMap,falg,chinaPNRSubstituteReq.getBatchNo());
        log.info("客代发业务执行完毕 ...batchNO=" + chinaPNRSubstituteReq.getBatchNo());

        if(falg){
            return ResultUtil.success(ResultEnum.CHINA_PNR_SUCCESS);
        }else{
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
    }

    /**
     * 客户还款汇差等代发通知
     * @param resXml
     * @return
     */
    @Override
    public ResponseMessage oldCallbackSubstitute(String resXml) {

        log.info("客户还款汇差等代发通知结果  xml = " + resXml);
        //签名
        ChinaPNROldSubstitute pay = new ChinaPNROldSubstitute();
        Map<String,String> resMap = pay.substituteCallback(resXml);
        if(!resMap.get("code").equals("0004")){
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
        //查询该批次下的数据
        ChinaPNRBatchPay chinaPNRBatchPay = new ChinaPNRBatchPay();
        chinaPNRBatchPay.setBatchNo(resMap.get("batchNo"));
        chinaPNRBatchPay = chinaPNRBatchPayMapper.selectOne(chinaPNRBatchPay);
        if(null == chinaPNRBatchPay){
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR.getCode(),"未找到batchNo【"+ resMap.get("batchNo") +"】的交易批次");
        }
        chinaPNRBatchPay.setResponseMessage(resMap.get("resText"));
        chinaPNRBatchPay.setHandleStatus("040");
        chinaPNRBatchPayMapper.updateByPrimaryKey(chinaPNRBatchPay);
        //回调明细数据
        String detailsCallback = resMap.get("details");
        //查询该批次下的交易明细
        ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay = new ChinaPNRBatchDetailedPay();
        chinaPNRBatchDetailedPay.setBatchNo(resMap.get("batchNo"));
        List<ChinaPNRBatchDetailedPay> detailList = chinaPNRBatchDetailedPayMapper.select(chinaPNRBatchDetailedPay);
        //返回结果明细为空 ，未发现代发错误结果
        if(null == detailsCallback || "".equals(detailsCallback)){
            log.info("回调的交易结果统一成功");
            for(ChinaPNRBatchDetailedPay detail : detailList){
                detail.setStatus("040"); //成功
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }else{ //有支付错误数据
            log.info("回调的结果查询到失败的交易记录 ：" + detailsCallback);
            String[] detailsArr = detailsCallback.split(";");
            for(ChinaPNRBatchDetailedPay detail : detailList){
                for(int i = 0; i < detailsArr.length;i++){
                    String [] detailsArr_s = detailsArr[i].split("|");
                    if(detail.getDetailedId().equals(detailsArr_s)){
                        log.info("回调旧版代发结果更新代发明细为失败 detailId=" + detail.getDetailedId());
                        detail.setStatus("030"); //失败
                    }
                }
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }
        //成功后组装回调信息
        String resultXml = pay.resultXml();
        return ResultUtil.success(resultXml,ResultEnum.CHINA_PNR_SUCCESS);
    }

    /**
     * 客户提现代发通知
     * @param map
     * @return
     */
    @Override
    public ResponseMessage newCallbackSubstitute(Map<String, String> map) {
        log.info("客户提现汇差等代发通知结果  batchNo = " + map.get("batchNo"));
        //签名
        ChinaPNRNewSubstitute pay = new ChinaPNRNewSubstitute();
        Map<String,String> resMap = pay.substituteCallback(map);
        if(!resMap.get("code").equals("0004")){
            log.info("客户还款回调结果错误 错误描述：" + resMap.get("msg"));
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR);
        }
        //查询该批次下的数据
        ChinaPNRBatchPay chinaPNRBatchPay = new ChinaPNRBatchPay();
        chinaPNRBatchPay.setBatchNo(map.get("batchNo"));
        chinaPNRBatchPay = chinaPNRBatchPayMapper.selectOne(chinaPNRBatchPay);
        if(null == chinaPNRBatchPay){
            return ResultUtil.error(ResultEnum.CHINA_PNR_ERROR.getCode(),"未找到提现batchNo【"+ map.get("batchNo") +"】的交易批次");
        }
        chinaPNRBatchPay.setResponseMessage(resMap.get("resText"));
        chinaPNRBatchPay.setHandleStatus("040");
        chinaPNRBatchPayMapper.updateByPrimaryKey(chinaPNRBatchPay);
        log.info("提现批次回调成功..更新数据");
        //回调明细数据
        String detailsCallback = map.get("details");
        //查询该批次下的交易明细
        ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay = new ChinaPNRBatchDetailedPay();
        chinaPNRBatchDetailedPay.setBatchNo(map.get("batchNo"));
        List<ChinaPNRBatchDetailedPay> detailList = chinaPNRBatchDetailedPayMapper.select(chinaPNRBatchDetailedPay);
        //返回结果明细为空 ，未发现代发错误结果
        if(null == detailsCallback || "".equals(detailsCallback)){
            log.info("回调的交易结果统一成功");
            for(ChinaPNRBatchDetailedPay detail : detailList){
                detail.setStatus("040"); //成功
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }else{ //有支付错误数据

            String[] detailsArr = detailsCallback.split(";");
            log.info("回调的结果查询到失败的交易记录 ：" + detailsArr.toString());
            for(ChinaPNRBatchDetailedPay detail : detailList){
                for(int i = 0; i < detailsArr.length;i++){
                    String [] detailsArr_s = detailsArr[i].split("|");
                    if(detail.getDetailedId().equals(detailsArr_s)){
                        log.info("回调结果更新代发明细为失败 detailId=" + detail.getDetailedId());
                        detail.setStatus("030"); //失败
                    }
                }
                chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(detail);
            }
        }
        return ResultUtil.success(ResultEnum.CHINA_PNR_SUCCESS);
    }


    /**
     * 客户提现查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @Override
    public ResponseMessage queryNewSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {

        log.info("客户代发客户提现业务查询执行 ...batchNO=" + chinaPNRSubstituteQueryReq.getBatchNo() + "明细流水：" + chinaPNRSubstituteQueryReq.getRemitNo());
        Map<String,String> res = new HashMap<>();

        ChinaPNRBatchDetailedPay selectChinaPNRBatchDetailed = new ChinaPNRBatchDetailedPay();
        selectChinaPNRBatchDetailed.setBatchNo(chinaPNRSubstituteQueryReq.getBatchNo());
        selectChinaPNRBatchDetailed.setDetailedId(chinaPNRSubstituteQueryReq.getRemitNo());
        selectChinaPNRBatchDetailed = chinaPNRBatchDetailedPayMapper.selectOne(selectChinaPNRBatchDetailed);

        if(!selectChinaPNRBatchDetailed.getStatus().equals("040")){
            //执行汇付代发功能查询
            ChinaPNRNewSubstitute pay = new ChinaPNRNewSubstitute();
            Map<String,String> resMap = pay.substituteQuery(chinaPNRSubstituteQueryReq);
            if("0004".equals(resMap.get("code"))){
                if("2".equals(resMap.get("status"))){ //成功
                    selectChinaPNRBatchDetailed.setStatus("040");
                }else if("3".equals(resMap.get("status"))){ //失败
                    selectChinaPNRBatchDetailed.setStatus("030");
                }else if("1".equals(resMap.get("status"))){ //处理中
                    selectChinaPNRBatchDetailed.setStatus("020");
                }else{
                    selectChinaPNRBatchDetailed.setStatus("010"); //初始化
                }
            }
            chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(selectChinaPNRBatchDetailed); //修改结果
        }
        res.put("detailedId",selectChinaPNRBatchDetailed.getDetailedId());
        res.put("batchNo",selectChinaPNRBatchDetailed.getBatchNo());
        res.put("substituteAmt",selectChinaPNRBatchDetailed.getSubstituteAmt().toPlainString());
        res.put("status",selectChinaPNRBatchDetailed.getStatus());

        return ResultUtil.success(res,ResultEnum.SUCCESS);
    }

    /**
     * 客户还款，还款服务费,汇差 ，提现服务费交易查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @Override
    public ResponseMessage queryOldSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq) {

        log.info("客户代发业务查询执行 ...batchNO=" + chinaPNRSubstituteQueryReq.getBatchNo() + "明细流水：" + chinaPNRSubstituteQueryReq.getRemitNo());
        Map<String,String> res = new HashMap<>();

        ChinaPNRBatchDetailedPay selectChinaPNRBatchDetailed = new ChinaPNRBatchDetailedPay();
        selectChinaPNRBatchDetailed.setBatchNo(chinaPNRSubstituteQueryReq.getBatchNo());
        selectChinaPNRBatchDetailed.setDetailedId(chinaPNRSubstituteQueryReq.getRemitNo());
        selectChinaPNRBatchDetailed = chinaPNRBatchDetailedPayMapper.selectOne(selectChinaPNRBatchDetailed);

        if(!selectChinaPNRBatchDetailed.getStatus().equals("040")){
            //执行汇付代发功能查询
            ChinaPNROldSubstitute pay = new ChinaPNROldSubstitute();
            Map<String,String> resMap = pay.substituteQuery(chinaPNRSubstituteQueryReq);
            if(resMap.get("code").equals("0004")){
                if(resMap.get("status").equals("2")){ //成功
                    selectChinaPNRBatchDetailed.setStatus("040");
                }else if(resMap.get("status").equals("3")){ //失败
                    selectChinaPNRBatchDetailed.setStatus("030");
                }else if(resMap.get("status").equals("1")){ //处理中
                    selectChinaPNRBatchDetailed.setStatus("020");
                }else{
                    selectChinaPNRBatchDetailed.setStatus("010"); //初始化
                }
            }
            chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(selectChinaPNRBatchDetailed); //修改结果
        }
        res.put("detailedId",selectChinaPNRBatchDetailed.getDetailedId());
        res.put("batchNo",selectChinaPNRBatchDetailed.getBatchNo());
        res.put("substituteAmt",selectChinaPNRBatchDetailed.getSubstituteAmt().toPlainString());
        res.put("status",selectChinaPNRBatchDetailed.getStatus());

        return ResultUtil.success(res,ResultEnum.SUCCESS);
    }

    /**
     * 执行代发前初始化批量和明细交易数据
     * @param chinaPNRSubstituteReq
     */
    public void batchChinaPayInsert(ChinaPNRSubstituteReq chinaPNRSubstituteReq,String result_url){
        //执行流水添加到数据库
        ChinaPNRBatchPay chinaPNRBatchPay = new ChinaPNRBatchPay();
        chinaPNRBatchPay.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        chinaPNRBatchPay.setBatchNo(chinaPNRSubstituteReq.getBatchNo());
        chinaPNRBatchPay.setRequestId(chinaPNRSubstituteReq.getRequestId());
        chinaPNRBatchPay.setRequestTime(new Date());
        chinaPNRBatchPay.setPayCur(chinaPNRSubstituteReq.getPayCur());
        chinaPNRBatchPay.setPayCnt(chinaPNRSubstituteReq.getPayTCnt());
        chinaPNRBatchPay.setPayAmt(chinaPNRSubstituteReq.getPayTAmt());
        chinaPNRBatchPay.setRemitType(chinaPNRSubstituteReq.getRemitType());
        chinaPNRBatchPay.setIgnoreFlag("1");//为1时，只要存在错误的明细行则整个批次失败
        chinaPNRBatchPay.setPurpose("代发");
        chinaPNRBatchPay.setNoticeUrl(result_url);
        chinaPNRBatchPay.setReceiveStatus("1");//全部接收成功
        chinaPNRBatchPay.setHandleStatus("010"); //初始化
        chinaPNRBatchPayMapper.insert(chinaPNRBatchPay);

        List<ChinaPNRBatchDetailedPay> detailedList = new ArrayList<>();
        List<ChinaPNRSubstituteDetails> substituteDetailsList = chinaPNRSubstituteReq.getDetailsList();
        for(ChinaPNRSubstituteDetails details : substituteDetailsList){
            ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay = new ChinaPNRBatchDetailedPay();
            chinaPNRBatchDetailedPay.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            chinaPNRBatchDetailedPay.setBatchNo(chinaPNRSubstituteReq.getBatchNo());
            chinaPNRBatchDetailedPay.setDetailedId(details.getSubstituteDetailId());
            chinaPNRBatchDetailedPay.setSubstituteAmt(details.getSubstituteDetailAmt());
            chinaPNRBatchDetailedPay.setPurpose(details.getPurpose());
            chinaPNRBatchDetailedPay.setStatus("010");
            chinaPNRBatchDetailedPay.setSubstituteType(details.getSubstituteType()); //交易类型
            chinaPNRBatchDetailedPay.setSubstituteType("040");
            detailedList.add(chinaPNRBatchDetailedPay);
        }
        chinaPNRBatchDetailedPayMapper.insertList(detailedList);
    }

    /**
     * 代发同步结果后更新交易流水
     * @param resMap
     * @param falg
     * @param batchNo
     */
    public void updateBatchChinaPNRPay(Map<String,String> resMap,boolean falg , String batchNo){
        ChinaPNRBatchPay selectChinaPNRBatch = new ChinaPNRBatchPay();
        selectChinaPNRBatch.setBatchNo(batchNo);
        selectChinaPNRBatch = chinaPNRBatchPayMapper.selectOne(selectChinaPNRBatch);

        if(falg){ //判断是否代发成功
            selectChinaPNRBatch.setHandleStatus("020");
        }else{
            selectChinaPNRBatch.setHandleStatus("030");
            selectChinaPNRBatch.setErrorCode(resMap.get("code"));
            selectChinaPNRBatch.setErrorMsg(resMap.get("msg"));
        }
        selectChinaPNRBatch.setRequestMessage(resMap.get("reqText"));
        selectChinaPNRBatch.setResponseMessage(resMap.get("resText"));
        chinaPNRBatchPayMapper.updateByPrimaryKey(selectChinaPNRBatch);

        ChinaPNRBatchDetailedPay selectChinaPNRBatchDetailed = new ChinaPNRBatchDetailedPay();
        selectChinaPNRBatchDetailed.setBatchNo(batchNo);
        List<ChinaPNRBatchDetailedPay> selectChinaPNRBatchDetailedList = chinaPNRBatchDetailedPayMapper.select(selectChinaPNRBatchDetailed);
        for(ChinaPNRBatchDetailedPay chinaPNRBatchDetailedPay : selectChinaPNRBatchDetailedList){
            if(falg){
                chinaPNRBatchDetailedPay.setStatus("020");
            }else{
                chinaPNRBatchDetailedPay.setStatus("030");
            }
            chinaPNRBatchDetailedPayMapper.updateByPrimaryKey(chinaPNRBatchDetailedPay);
        }
    }
}
