package com.js.pay.service.chinapnr.impl;

import com.alibaba.fastjson.JSON;
import com.js.api.jspay.service.chinapnr.ChinaPNRPayOpenAccountService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.ChinaPNREnterpriseOpenAccountReq;
import com.js.common.model.req.ChinaPNRPersonalOpenAccountReq;
import com.js.common.model.req.ChinaPNRQueryOpenAccountReq;
import com.js.common.model.vo.ChinaPNROpenAccountVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.dal.dao.mapper.ChinaPNROpenAccountMapper;
import com.js.dal.dao.mapper.ChinaPNRTradingFlowMapper;
import com.js.dal.dao.model.ChinaPNROpenAccount;
import com.js.dal.dao.model.ChinaPNRTradingFlow;
import com.js.dal.dao.service.impl.IBaseServiceImpl;
import com.js.pay.service.JsFileForOSSSerivce;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

/**
 * @Description:汇付天下开户
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Service(
        protocol = {"rest", "dubbo"},
        version = Constant.DUBBO_VERSION,
        application = "${dubbo.application.id}",
        registry = "${dubbo.registry.id}"
)
@Slf4j
public class ChinaPNRPayOpenAccountServiceImpl extends IBaseServiceImpl<ChinaPNROpenAccount> implements ChinaPNRPayOpenAccountService {

    @Autowired
    private ChinaPNROpenAccountMapper chinaPNROpenAccountMapper;

    @Autowired
    private ChinaPNRTradingFlowMapper chinaPNRTradingFlowMapper;

    @Autowired
    JsFileForOSSSerivce jsFileForOSSSerivce;

    /**
     * 个人开户
     * @param chinaPNRPersonalOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq) {
        //个人开户
        log.info("汇付个人信息开户 执行 " + chinaPNRPersonalOpenAccountReq.toString()) ;

        if(StringUtils.isNotBlank(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyF())){
            chinaPNRPersonalOpenAccountReq.setCertPhotoCopyF(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyF())));
        }
        if(StringUtils.isNotBlank(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyB())){
            chinaPNRPersonalOpenAccountReq.setCertPhotoCopyB(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNRPersonalOpenAccountReq.getCertPhotoCopyB())));
        }
        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccount = new ChinaPNROpenAccount();
        chinaPNROpenAccount.setKycNaturalId(chinaPNRPersonalOpenAccountReq.getKycNaturalId());
        chinaPNROpenAccount.setOpenAccountType("0");
        chinaPNROpenAccount = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccount);

        com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount pay = new com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount();
        Map<String,String> payMap = null;
        if(null != chinaPNROpenAccount){
            if(chinaPNROpenAccount.getResult().equals("0")){ //已经开户
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS.getCode(),ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS.getMsg());
            }
            //查询汇付开户结果
            ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq = new ChinaPNRQueryOpenAccountReq();
            chinaPNRQueryOpenAccountReq.setRequestId(UUID.randomUUID().toString().replaceAll("-", ""));
            chinaPNRQueryOpenAccountReq.setKycNaturalId(chinaPNROpenAccount.getJsOpenAccountNo());
            chinaPNRQueryOpenAccountReq.setJsOpenAccountNo(chinaPNROpenAccount.getJsOpenAccountNo());
            Map<String,String> resMap = pay.queryPersonalOpenAccount(chinaPNRQueryOpenAccountReq);
            if(!resMap.get("code").equals("0004")){
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getMsg());
            }
            if(resMap.get("result").equals("0")){
                chinaPNROpenAccount.setResult(resMap.get("result"));
                chinaPNROpenAccount.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
                chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }
            //查询结果开户失败，则重新进行开户
            payMap = pay.personalOpenAccount(chinaPNRPersonalOpenAccountReq);
            if(!"0004".equals(payMap.get("code"))){
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
            }
            if(payMap.get("result").equals("0")){ //成功
                chinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
                chinaPNROpenAccount.setResult("0");
            }else if("2".equals(payMap.get("result"))){//审核中
                chinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
                chinaPNROpenAccount.setResult("2");
            }else{
                chinaPNROpenAccount.setResult("1"); //失败

            }
            chinaPNROpenAccount.setJsOpenAccountNo(chinaPNRPersonalOpenAccountReq.getJsOpenAccountNo());
            chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);

        }else{
            //请求开户
            payMap = pay.personalOpenAccount(chinaPNRPersonalOpenAccountReq);
            if(!payMap.get("code").equals("0004")){
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
            }
            //创建开户流水信息和开户信息
            ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
            chinaPNRTradingFlow.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            chinaPNRTradingFlow.setJsTradingFlowId(chinaPNRPersonalOpenAccountReq.getRequestId());
            chinaPNRTradingFlow.setKycNaturalId(chinaPNRPersonalOpenAccountReq.getKycNaturalId());
            chinaPNRTradingFlow.setTransactionType("0");
            chinaPNRTradingFlow.setTransactionTime(new Date());
            chinaPNRTradingFlow.setResult(payMap.get("result"));
            chinaPNRTradingFlow.setRequestMessage(payMap.get("reqText"));
            chinaPNRTradingFlow.setCreateDts(new Date());
            chinaPNRTradingFlow.setUpdateDts(new Date());
            chinaPNRTradingFlow.setResponseMessage(payMap.get("resText"));
            chinaPNRTradingFlowMapper.insert(chinaPNRTradingFlow);

            ChinaPNROpenAccount newChinaPNROpenAccount = new ChinaPNROpenAccount();
            newChinaPNROpenAccount.setCertId(UUID.randomUUID().toString().replaceAll("-", ""));
            newChinaPNROpenAccount.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            newChinaPNROpenAccount.setJsOpenAccountNo(chinaPNRPersonalOpenAccountReq.getJsOpenAccountNo());
            newChinaPNROpenAccount.setKycNaturalId(chinaPNRPersonalOpenAccountReq.getKycNaturalId());
            newChinaPNROpenAccount.setName(chinaPNRPersonalOpenAccountReq.getName());
            newChinaPNROpenAccount.setCertType(chinaPNRPersonalOpenAccountReq.getCertType());
            newChinaPNROpenAccount.setCertId(chinaPNRPersonalOpenAccountReq.getCertId());
            newChinaPNROpenAccount.setCertExpDateEnd(chinaPNRPersonalOpenAccountReq.getCertExpDateEnd());
            newChinaPNROpenAccount.setMobileNumber(chinaPNRPersonalOpenAccountReq.getMobileNumber());
            newChinaPNROpenAccount.setEmail(chinaPNRPersonalOpenAccountReq.getEmail());
            newChinaPNROpenAccount.setBankCode(chinaPNRPersonalOpenAccountReq.getBankCode());
            newChinaPNROpenAccount.setAcctType("2");
            newChinaPNROpenAccount.setBankAcct(chinaPNRPersonalOpenAccountReq.getBankAcct());
            newChinaPNROpenAccount.setAcctName(chinaPNRPersonalOpenAccountReq.getAcctName());
            newChinaPNROpenAccount.setAddress(chinaPNRPersonalOpenAccountReq.getAddress());
            if(payMap.get("result").equals("0")){ //开户成功
                newChinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
            }else if(payMap.get("result").equals("2")){
                newChinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
            }
            newChinaPNROpenAccount.setResult(payMap.get("result"));
            newChinaPNROpenAccount.setOpenAccountType("0");
            newChinaPNROpenAccount.setOpenAccountDate(new Date());
            newChinaPNROpenAccount.setUpdateDts(new Date());
            chinaPNROpenAccountMapper.insert(newChinaPNROpenAccount);
        }
        if(payMap.get("result").equals("1")){
            return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }else{
            return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
        }
    }

    /**
     * 企业开户
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq) {
        //个人开户
        log.info("汇付企业信息开户 执行  " + chinaPNROpenAccountReq.toString()) ;

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccount = new ChinaPNROpenAccount();
        chinaPNROpenAccount.setKycNaturalId(chinaPNROpenAccountReq.getKycNaturalId());
        chinaPNROpenAccount.setOpenAccountType("1");
        chinaPNROpenAccount = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccount);

        //图片转换BASE64
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getLegalCertPhotoCopyF())){
            chinaPNROpenAccountReq.setLegalCertPhotoCopyF(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getLegalCertPhotoCopyF())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getLegalCertPhotoCopyB())){
            chinaPNROpenAccountReq.setLegalCertPhotoCopyB(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getLegalCertPhotoCopyB())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getBizLicensePhotoCopy())){
            chinaPNROpenAccountReq.setBizLicensePhotoCopy(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getBizLicensePhotoCopy())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getOrgPhotoCopy())){
            chinaPNROpenAccountReq.setOrgPhotoCopy(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getOrgPhotoCopy())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getTaxRegPhotoCopy())){
            chinaPNROpenAccountReq.setTaxRegPhotoCopy(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getTaxRegPhotoCopy())));
        }
        if(StringUtils.isNotBlank(chinaPNROpenAccountReq.getOpenLicensePhotoCopy())){
            chinaPNROpenAccountReq.setOpenLicensePhotoCopy(ChinaPNRCommons.getImageStr(jsFileForOSSSerivce.findFile(chinaPNROpenAccountReq.getOpenLicensePhotoCopy())));
        }

        com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount pay = new com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount();
        Map<String,String> payMap = null;
        if(null != chinaPNROpenAccount){
            if(chinaPNROpenAccount.getResult().equals("0")){ //已经开户
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }
            //查询汇付开户结果
            ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq = new ChinaPNRQueryOpenAccountReq();
            chinaPNRQueryOpenAccountReq.setRequestId(UUID.randomUUID().toString().replaceAll("-", ""));
            chinaPNRQueryOpenAccountReq.setKycNaturalId(chinaPNROpenAccountReq.getKycNaturalId());
            chinaPNRQueryOpenAccountReq.setJsOpenAccountNo(chinaPNROpenAccountReq.getJsOpenAccountNo());
            Map<String,String> resMap = pay.queryEnterpriseOpenAccount(chinaPNRQueryOpenAccountReq);
            if(!"0004".equals(resMap.get("code"))){
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
            }
            if("0".equals(resMap.get("result"))){
                chinaPNROpenAccount.setResult(resMap.get("result"));
                chinaPNROpenAccount.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
                chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }
            //查询结果开户失败，则重新进行开户
            payMap = pay.enterpriseOpenAccount(chinaPNROpenAccountReq);
            if(!"0004".equals(payMap.get("code"))){
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
            }
            if("0".equals(payMap.get("result"))){ //成功
                chinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
                chinaPNROpenAccount.setResult("0");
            }else if("2".equals(payMap.get("result"))){//审核中
                chinaPNROpenAccount.setResult("2");
                chinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
            }else{
                chinaPNROpenAccount.setResult("1"); //失败
            }
            chinaPNROpenAccount.setJsOpenAccountNo(chinaPNROpenAccountReq.getJsOpenAccountNo());
            chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);

        }else{
            //请求开户
            payMap = pay.enterpriseOpenAccount(chinaPNROpenAccountReq);
            if(!"0004".equals(payMap.get("code"))){
                return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
            }
            //创建开户流水信息和开户信息
            ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
            chinaPNRTradingFlow.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            chinaPNRTradingFlow.setKycNaturalId(chinaPNROpenAccountReq.getKycNaturalId());
            chinaPNRTradingFlow.setTransactionType("0");
            chinaPNRTradingFlow.setRequestMessage(payMap.get("reqText"));
            chinaPNRTradingFlow.setJsTradingFlowId(chinaPNROpenAccountReq.getRequestId());
            chinaPNRTradingFlow.setTransactionTime(new Date());
            chinaPNRTradingFlow.setResponseMessage(payMap.get("resText"));
            chinaPNRTradingFlow.setResult(payMap.get("result"));
            chinaPNRTradingFlow.setCreateDts(new Date());
            chinaPNRTradingFlow.setUpdateDts(new Date());
            chinaPNRTradingFlowMapper.insert(chinaPNRTradingFlow);

            ChinaPNROpenAccount newChinaPNROpenAccount = new ChinaPNROpenAccount();
            newChinaPNROpenAccount.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            newChinaPNROpenAccount.setJsOpenAccountNo(chinaPNROpenAccountReq.getJsOpenAccountNo());
            newChinaPNROpenAccount.setKycNaturalId(chinaPNROpenAccountReq.getKycNaturalId());
            newChinaPNROpenAccount.setName(chinaPNROpenAccountReq.getName());
            newChinaPNROpenAccount.setCertType(chinaPNROpenAccountReq.getLegalCertType());
            newChinaPNROpenAccount.setCertId(chinaPNROpenAccountReq.getLegalCertId());
            newChinaPNROpenAccount.setCertExpDateEnd(chinaPNROpenAccountReq.getLegalCertExpDateEnd());
            newChinaPNROpenAccount.setMobileNumber(chinaPNROpenAccountReq.getPhone());
            newChinaPNROpenAccount.setEmail("");
            newChinaPNROpenAccount.setOpenAccountType("1");
            newChinaPNROpenAccount.setAcctType("2");
            newChinaPNROpenAccount.setBankAcct(chinaPNROpenAccountReq.getBankAcct());
            newChinaPNROpenAccount.setBankCode(chinaPNROpenAccountReq.getBankCode());
            newChinaPNROpenAccount.setAcctName(chinaPNROpenAccountReq.getAcctName());
            if(payMap.get("result").equals("0")){ //开户成功
                newChinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
            }else if(payMap.get("result").equals("2")){
                newChinaPNROpenAccount.setChinaPnrOpenAccountNo(payMap.get("chinaPNRUserId"));
            }
            newChinaPNROpenAccount.setAddress(chinaPNROpenAccountReq.getAddress());
            newChinaPNROpenAccount.setResult(payMap.get("result"));
            newChinaPNROpenAccount.setOpenAccountDate(new Date());
            newChinaPNROpenAccount.setUpdateDts(new Date());
            chinaPNROpenAccountMapper.insert(newChinaPNROpenAccount);
        }
        if(payMap.get("result").equals("1")){
            return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }else{
            return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
        }
    }

    /**
     * 个人开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalUpdateOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq) {
        return null;
    }

    /**
     * 企业开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseUpdateOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq) {
        return null;
    }

    /**
     * 个人开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage personalQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        //个人开户
        log.info("汇付个人信息开户查询 执行 userid = " + chinaPNRQueryOpenAccountReq.getKycNaturalId() + "RequestId = " + chinaPNRQueryOpenAccountReq.getRequestId()) ;

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccount = new ChinaPNROpenAccount();
        chinaPNROpenAccount.setKycNaturalId(chinaPNRQueryOpenAccountReq.getKycNaturalId());
        chinaPNROpenAccount.setOpenAccountType("0");
        chinaPNROpenAccount.setJsOpenAccountNo(chinaPNRQueryOpenAccountReq.getJsOpenAccountNo());
        chinaPNROpenAccount = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccount);

        if(null == chinaPNROpenAccount){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"未查询到个人开户信息");
        }else{
            if(chinaPNROpenAccount.getResult().equals("0")){
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }
        }
        com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount pay = new com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount();
        Map<String,String> resMap = pay.queryPersonalOpenAccount(chinaPNRQueryOpenAccountReq);
        if(!resMap.get("code").equals("0004")){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(resMap.get("result").equals("0")){ //成功
            chinaPNROpenAccount.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccount.setResult("0");
        }else if(resMap.get("result").equals("2")){//审核中
            chinaPNROpenAccount.setResult("2");
        }else{
            chinaPNROpenAccount.setResult("1"); //失败
        }
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
    }

    /**
     * 企业开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    @Override
    public ResponseMessage enterpriseQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq) {
        //企业开户查询
        log.info("汇付企业信息开户查询 执行 userid = " + chinaPNRQueryOpenAccountReq.getKycNaturalId() + "RequestId = " + chinaPNRQueryOpenAccountReq.getRequestId()) ;

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccount = new ChinaPNROpenAccount();
        chinaPNROpenAccount.setKycNaturalId(chinaPNRQueryOpenAccountReq.getKycNaturalId());
        chinaPNROpenAccount.setOpenAccountType("1");
        chinaPNROpenAccount.setJsOpenAccountNo(chinaPNRQueryOpenAccountReq.getJsOpenAccountNo());
        chinaPNROpenAccount = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccount);
        if(null == chinaPNROpenAccount){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR.getCode(),"未查询到企业开户信息");
        }else{
            if(chinaPNROpenAccount.getResult().equals("0")){
                return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
            }
        }
        com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount pay = new com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount();
        Map<String,String> resMap = pay.queryEnterpriseOpenAccount(chinaPNRQueryOpenAccountReq);
        if(!"0004".equals(resMap.get("code"))){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if("0".equals(resMap.get("result"))){ //成功
            chinaPNROpenAccount.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccount.setResult("0");
        }else if(resMap.get("result").equals("2")){//审核中
            chinaPNROpenAccount.setResult("2");
        }else{
            chinaPNROpenAccount.setResult("1"); //失败
        }
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
    }

    /**
     * 企业开户信息回调
     * @param map
     * @return
     */
    @Override
    public ResponseMessage enterpriseCallbackOpenAccount(Map<String, String> map) {

        log.info(" 企业开户信息回调  userid = " + map.get("platformUserId")) ;
        //验签
        com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount pay = new com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount();
        Map<String,String> resMap = pay.callbackEnterpriseOpenAccount(map);

        if(!"0004".equals(resMap.get("code"))){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        //查询开户信息
        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccount = new ChinaPNROpenAccount();
        chinaPNROpenAccount.setJsOpenAccountNo(map.get("platformUserId"));
        chinaPNROpenAccount.setOpenAccountType("1");
        chinaPNROpenAccount = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccount);
        if(null == chinaPNROpenAccount){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if("0".equals(resMap.get("result"))){ //成功
            chinaPNROpenAccount.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccount.setResult("0");
        }else if(resMap.get("result").equals("2")){//审核中
            chinaPNROpenAccount.setResult("2");
        }else{
            chinaPNROpenAccount.setResult("1"); //失败
        }
        log.info("企业回调成功 result= " + resMap.get("result"));
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);

        //更新请求流水结果
        //创建开户流水信息和开户信息
        ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
        chinaPNRTradingFlow.setJsTradingFlowId(map.get("requestId"));
        chinaPNRTradingFlow = chinaPNRTradingFlowMapper.selectOne(chinaPNRTradingFlow);
        if(null != chinaPNRTradingFlow){
            chinaPNRTradingFlow.setResponseMessage(resMap.get("resText"));
            chinaPNRTradingFlow.setResult(resMap.get("result"));
            chinaPNRTradingFlowMapper.updateByPrimaryKey(chinaPNRTradingFlow);
        }
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);
    }

    /**
     * 个人开户信息回调
     * @param map
     * @return
     */
    @Override
    public ResponseMessage personalCallbackOpenAccount(Map<String, String> map) {
        log.info(" 个人开户信息回调  userid = " + map.get("platformUserId")) ;
        //验签
        com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount pay = new com.js.pay.service.chinapnr.example.pay.ChinaPNROpenAccount();
        Map<String,String> resMap = pay.callbackPersonalOpenAccount(map);
        log.info("开户回调resMap解析结果=" + resMap.toString());

        if(!resMap.get("code").equals("0004")){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccount = new ChinaPNROpenAccount();
        chinaPNROpenAccount.setJsOpenAccountNo(map.get("platformUserId"));
        chinaPNROpenAccount.setOpenAccountType("0");
        chinaPNROpenAccount = chinaPNROpenAccountMapper.selectOne(chinaPNROpenAccount);
        if(null == chinaPNROpenAccount){
            return ResultUtil.error(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_ERROR);
        }
        if(resMap.get("result").equals("0")){ //成功
            chinaPNROpenAccount.setChinaPnrOpenAccountNo(resMap.get("chinaPNRUserId"));
            chinaPNROpenAccount.setResult("0");
        }else if(resMap.get("result").equals("2")){//审核中
            chinaPNROpenAccount.setResult("2");
        }else{
            chinaPNROpenAccount.setResult("1"); //失败
        }
        log.info("个人回调成功 result= " + resMap.get("result"));
        chinaPNROpenAccountMapper.updateByPrimaryKey(chinaPNROpenAccount);

        //更新请求流水结果
        //创建开户流水信息和开户信息
        ChinaPNRTradingFlow chinaPNRTradingFlow = new ChinaPNRTradingFlow();
        chinaPNRTradingFlow.setJsTradingFlowId(map.get("requestId"));
        chinaPNRTradingFlow = chinaPNRTradingFlowMapper.selectOne(chinaPNRTradingFlow);
        if(null!= chinaPNRTradingFlow){
            chinaPNRTradingFlow.setResult(resMap.get("result"));
            chinaPNRTradingFlow.setResponseMessage(resMap.get("resText"));
            chinaPNRTradingFlowMapper.updateByPrimaryKey(chinaPNRTradingFlow);
        }
        return ResultUtil.success(ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS);

    }

    @Override
    public ResponseMessage queryOpenAccount(String kycNautralId,String result) {
        log.info("js方开户查询 执行 userid = {}" , kycNautralId) ;

        //查询该用户是否已经开户
        ChinaPNROpenAccount chinaPNROpenAccountQuery = new ChinaPNROpenAccount();
        chinaPNROpenAccountQuery.setKycNaturalId(kycNautralId);
        chinaPNROpenAccountQuery.setResult(result);
        ChinaPNROpenAccount chinaPNROpenAccount = iBaseMapper.selectOne(chinaPNROpenAccountQuery);
        if(null == chinaPNROpenAccount){
            log.error("未查询到汇付开户信息");
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST);
        }
        log.info("查询到汇付开户信息：{}", JSON.toJSONString(chinaPNROpenAccount));
        ChinaPNROpenAccountVO chinaPNROpenAccountVO = new ChinaPNROpenAccountVO();
        BeanUtils.copyProperties(chinaPNROpenAccount,chinaPNROpenAccountVO);
        return ResultUtil.success(chinaPNROpenAccountVO);
    }
}
