package com.js.pay.service.chinapnr.example.utils;

import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.w3c.dom.Document;

import javax.xml.crypto.dsig.*;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import java.io.*;
import java.security.*;
import java.util.Collections;

public class SignatureUtil {

	public static String dataSignature(byte data[], String pemPath, final String pemPassword) {
		KeyPair keyPair = null;
		InputStream is = null;
		Security.addProvider(new BouncyCastleProvider());
		
		String classPath = SignatureUtil.class.getResource("/").toString()
				.replace("file:/", "");
		try {
			is = new FileInputStream(new File(classPath + "cert/env/" + 
		//System.getProperty("STAGE_ID") +"/" + 
					pemPath));
			if (is != null) {
				Reader fRd = null;
				PEMReader pemRd = null;
				try {
					fRd = new BufferedReader(new InputStreamReader(is));
					pemRd = new PEMReader(fRd, new PasswordFinder() {
						public char[] getPassword() {
							return pemPassword.toCharArray();
						}
					});
					keyPair = (KeyPair) pemRd.readObject();
				} catch (IOException e) {
					e.printStackTrace();
				} finally {
					if (fRd != null) {
						try {
							fRd.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}
			}
			PrivateKey pemKey = keyPair.getPrivate();
			Signature signature = Signature.getInstance("SHA1WithRSA");
			signature.initSign(pemKey);
			signature.update(data);
			byte[] signed = Base64.encodeBase64(signature.sign());
			return new String(signed);
		} catch (InvalidKeyException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (SignatureException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static Document xmlSignature(Document doc, String envType,
			String memberCode, String password, String aliasName)
			throws Exception {
		XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");

		// Create a Reference to the enveloped document (in this case we are
		// signing the whole document, so a URI of "" signifies that) and
		// also specify the SHA1 digest algorithm and the ENVELOPED Transform.
		Reference ref = fac.newReference("", fac.newDigestMethod(
				DigestMethod.SHA1, null), Collections.singletonList(fac
				.newTransform(Transform.ENVELOPED,
						(TransformParameterSpec) null)), null, null);

		// Create the SignedInfo
		SignedInfo si = fac
				.newSignedInfo(fac.newCanonicalizationMethod(
						CanonicalizationMethod.INCLUSIVE_WITH_COMMENTS,
						(C14NMethodParameterSpec) null), fac
						.newSignatureMethod(SignatureMethod.RSA_SHA1, null),
						Collections.singletonList(ref));

		PrivateKey privateKey = KeyProvider.getPrivateKey(envType, memberCode,
				password, password, aliasName, "PKCS12");

		// Create a DOMSignContext and specify the DSA PrivateKey and
		// location of the resulting XMLSignature's parent element
		DOMSignContext dsc = new DOMSignContext(privateKey,
				doc.getDocumentElement());

		// Create the XMLSignature (but don't sign it yet)
		XMLSignature signature = fac.newXMLSignature(si, null);

		// Marshal, generate (and sign) the enveloped signature
		signature.sign(dsc);

		// output the resulting document
		return doc;

	}

	/**
	 * 返回验签
	 * @param doc
	 * @return
	 */
	public static boolean veryfySignature(Document doc) throws Exception {

		Key key = KeyProvider.getServerPublicKey();
		return XMLSecurityUtils.veryfySignature(doc,key);
	}

}
