package com.js.pay.service.chinapnr.example.pay;

import com.js.common.model.req.ChinaPNRSubstituteDetails;
import com.js.common.model.req.ChinaPNRSubstituteQueryReq;
import com.js.common.model.req.ChinaPNRSubstituteReq;
import com.js.pay.service.chinapnr.example.ChinaPNRCommons;
import com.js.pay.service.chinapnr.example.DateUtils;
import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLSecurityProcess;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import common.util.httpclient.impl.HttpClientServiceImpl;
import common.util.httpclient.impl.SimpleHttpsClientImpl;
import lombok.extern.slf4j.Slf4j;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 汇付国际旧版本的代发功能 - 完成 提现 汇差 还款服务费功能
 */
@Slf4j
public class ChinaPNROldSubstitute {

    /**
     * 代发
     * @param req
     * @return
     */
    public Map<String,String> substitute(ChinaPNRSubstituteReq req){

        Map<String , String>  parameter = new HashMap<>();
        Map<String , String>  resMap = new HashMap<>();

        parameter.put("MERCHANTID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID"));//商户号
        parameter.put("TERMINALID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TERMINALID")); //终端号
        parameter.put("PRODUCTTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_PRODUCTTYPE"));//产品类型
        parameter.put("VERSION", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_VERSION"));//接口版本
        parameter.put("TRXTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DF")); //交易类别

        parameter.put("BATCH_NO",req.getBatchNo());
        parameter.put("REQTIME", DateUtils.LONG_DATE_FORMAT_SSS.format(new Date()));
        parameter.put("PAY_CUR",req.getPayCur());
        parameter.put("PAY_TCNT", req.getPayTCnt() + "");
        parameter.put("PAY_TAMT",req.getPayTAmt().toPlainString());

        parameter.put("PURPOSE","代发");
        parameter.put("EXT1","EXT1");
        parameter.put("EXT2","EXT1");
        parameter.put("RESULT_URL", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_OLD_RESULT_URL"));

        StringBuilder detailsStr = new StringBuilder();
        List<ChinaPNRSubstituteDetails> detailsList = req.getDetailsList();
        int detailSize = detailsList.size(); //大小
        //明细
        for(int i = 0 ; i < detailSize ; i++){

            ChinaPNRSubstituteDetails details = detailsList.get(i);
            detailsStr.append(details.getSubstituteDetailId())
                    .append("|")
                    .append(details.getSubstituteDetailAmt())
                    .append("|")
                    .append(details.getReceivablesBankCode())
                    .append("|")
                    .append(details.getReceivablesAccType())
                    .append("|")
                    .append(details.getAccountNumbe())
                    .append("|")
                    .append(details.getAccountName())
                    .append("|")
                    .append(details.getDocumentType())
                    .append("|")
                    .append(details.getIdentificationNumber())
                    .append("|")
                    .append(details.getProvince())
                    .append("|")
                    .append(details.getRegion())
                    .append("|")
                    .append(details.getBranchName())
                    .append("|")
                    .append(details.getPurpose())
                    .append("|")
                    .append("T" + ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DF"))
                    .append("|")
                    .append("ext1")
                    .append("|")
                    .append("ext2");
            if(detailSize > i + 1){
                detailsStr.append(";");
            }

        }
        parameter.put("DETAILS",detailsStr.toString());

        HttpSendResult result = getSubstituteXml(parameter,
                  ChinaPNRCommons.getPropertiesParam("CHINA_PNR_POSTURL"),
                  ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DF"));
        //0001失败0004成功
        if (null ==  result) {
            resMap.put("code","0001");
            resMap.put("msg","网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code","0001");
            resMap.put("msg","网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        String respTxt = result.getResponseBody();
        //返回验签
        Document resDoc = null;
        boolean veryfyResult = false;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc);

        }catch (Exception e){
            log.error("汇付旧版代发返回信息验签异常");
            resMap.put("code","0001");
            resMap.put("msg","汇付旧版代发返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("汇付旧版代发返回信息验签失败");
            resMap.put("code","0001");
            resMap.put("msg","汇付旧版代发返回信息验签失败");
            return resMap;
        }

        resMap.put("reqText",parameter.toString());
        resMap.put("resText",respTxt);
        //Document resDoc = ChinaPNRCommons.StringTOXml(respTxt);
        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        if(!nodeValue.equals("1")){
            String msgNodePath = "/RESPONSE/PARAMS/ERRERMSG";
            String msgNodeValue = ChinaPNRCommons.getNodeValue(resDoc, msgNodePath);
            resMap.put("code","0001");
            resMap.put("msg",msgNodeValue);
            return resMap;
        }
        resMap.put("code","0004");
        resMap.put("msg","成功");
        return resMap;
    }

    /**
     * 代发单笔交易查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    public Map<String,String> substituteQuery(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq){

        Map<String , String>  parameter = new HashMap<>();
        Map<String , String>  resMap = new HashMap<>();
        parameter.put("TRXTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DFCX")); //交易类别

        parameter.put("MERCHANTID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID"));//商户号
        parameter.put("TERMINALID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TERMINALID")); //终端号
        parameter.put("PRODUCTTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_PRODUCTTYPE"));//产品类型
        parameter.put("VERSION", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_VERSION"));//接口版本

        parameter.put("BATCH_NO",chinaPNRSubstituteQueryReq.getBatchNo());
        parameter.put("REMIT_REQ_ID",chinaPNRSubstituteQueryReq.getRemitNo());
        parameter.put("APPLY_DATE",chinaPNRSubstituteQueryReq.getApplyDate());

        HttpSendResult result = getSubstituteXml(parameter,
                ChinaPNRCommons.getPropertiesParam("CHINA_PNR_QUERYURL"),
                ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DFCX"));
        //0001失败0004成功
        if (null == result) {
            resMap.put("code","0001");
            resMap.put("msg","查询-网关系统异常");
            return resMap;
        }
        if(result.getStatus() != 200){
            resMap.put("code","0001");
            resMap.put("msg","查询-网关系统异常,状态码[" + result.getStatus() + "]");
            return resMap;
        }
        String respTxt = result.getResponseBody();

        //返回验签
        Document resDoc = null;
        boolean veryfyResult = false;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc);

        }catch (Exception e){
            log.error("查询汇付旧版代发返回信息验签异常");
            resMap.put("code","0001");
            resMap.put("msg","查询汇付旧版代发返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("查询汇付旧版代发返回信息验签失败");
            resMap.put("code","0001");
            resMap.put("msg","查询汇付旧版代发返回信息验签失败");
            return resMap;
        }

        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        String codeNodePath = "/RESPONSE/PARAMS/ERRERCODE";
        //String codeNodeValue = ChinaPNRCommons.getNodeValue(resDoc, codeNodePath);
        String msgNodePath = "/RESPONSE/PARAMS/ERRERMSG";
        String msgNodeValue = ChinaPNRCommons.getNodeValue(resDoc, msgNodePath);
        String amtNodePath = "/RESPONSE/PARAMS/AMT";
        String amtNodeValue = ChinaPNRCommons.getNodeValue(resDoc, amtNodePath);
        resMap.put("status",nodeValue);
        resMap.put("code","0004");
        resMap.put("msg",msgNodeValue);
        resMap.put("amt",amtNodeValue);
        return resMap;
    }

    /**
     * 代发回调
     * @param resXml
     * @return
     */
    public Map<String,String> substituteCallback(String resXml){

        Map<String , String>  resMap = new HashMap<>();
        //返回验签
        Document resDoc = null;
        boolean veryfyResult = false;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(resXml.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();
            veryfyResult = XMLSecurityProcess.veryfySignature(resDoc);

        }catch (Exception e){
            log.error("回调汇付旧版代发返回信息验签异常");
            resMap.put("code","0001");
            resMap.put("msg","回调汇付旧版代发返回信息验签异常");
            return resMap;
        }

        if(!veryfyResult){
            log.info("回调汇付旧版代发返回信息验签失败");
            resMap.put("code","0001");
            resMap.put("msg","回调汇付旧版代发返回信息验签失败");
            return resMap;
        }
        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodeValue = ChinaPNRCommons.getNodeValue(resDoc, nodePath);
        if(!nodeValue.equals("1")){
            String msgNodePath = "/RESPONSE/PARAMS/ERRERMSG";
            String msgNodeValue = ChinaPNRCommons.getNodeValue(resDoc, msgNodePath);
            resMap.put("code","0001");
            resMap.put("msg","回调-" + msgNodeValue);
            return resMap;
        }
        String nodePathBatchNo = "/RESPONSE/PARAMS/BATCH_NO";
        String nodeValueBatchNo = ChinaPNRCommons.getNodeValue(resDoc, nodePathBatchNo);
        String nodePathDetails = "/RESPONSE/PARAMS/DETAILS";
        String nodeValueDetails = ChinaPNRCommons.getNodeValue(resDoc, nodePathDetails);
        resMap.put("resText",resXml);
        resMap.put("batchNo",nodeValueBatchNo);
        resMap.put("details",nodeValueDetails);
        resMap.put("code","0004");
        resMap.put("msg","汇付旧版回调代发成功");
        return resMap;
    }

    /**
     * 处理汇付代发报文
     * @return
     */
    public static HttpSendResult getSubstituteXml(Map<String ,String> parameter,String url,String trxtype){
        HttpSendResult result = null;
        try {
            String requestXml = ChinaPNRCommons.transferToXML(parameter, trxtype);
            Document doc = XMLUtil.str2Doc(requestXml,"utf-8");
            SignatureUtil.xmlSignature(doc, ChinaPNRCommons.getPropertiesParam("CHINA_PNR_ENVTYPE"), ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID")
                            .substring(0, ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID").length()-2),
                    ChinaPNRCommons.getPropertiesParam("CHINA_PNR_PASSWORD"),
                    ChinaPNRCommons.getPropertiesParam("CHINA_PNR_ALIASNAME"));
            requestXml = XMLUtil.doc2Str(doc,"utf-8");
            //创建context
            HttpRequestContext context = new HttpRequestContext();
            context.setUrl(url);
            context.setHttpMethod(HttpRequestContext.POST_METHOD);
            context.setRequestCharset("utf-8");
            context.setResponseCharset("utf-8");
            context.setXml(requestXml);
            HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
            SimpleHttpsClientImpl shcic = new SimpleHttpsClientImpl();
            httpClient.setHttpsClient(shcic);
            result = httpClient.sendRequest(context);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 回调成功后返回通知成功结果
     * @return
     */
    public String resultXml(){

        Map<String , String>  parameter = new HashMap<>();
        parameter.put("TRXTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DFHD")); //交易类别
        parameter.put("PRODUCTTYPE", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_PRODUCTTYPE"));//产品类型
        parameter.put("MERCHANTID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_MERCHANTID"));//商户号
        parameter.put("TERMINALID", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TERMINALID")); //终端号
        parameter.put("VERSION", ChinaPNRCommons.getPropertiesParam("CHINA_PNR_VERSION"));//接口版本
        parameter.put("RESULT", "000000");//接口版本

        String requestXml = ChinaPNRCommons.transferToXML(parameter, ChinaPNRCommons.getPropertiesParam("CHINA_PNR_TRXTYPE_DFHD"));
        return requestXml;
    }

}
