package com.js.pay.service.chinapnr.example;

import com.js.pay.service.chinapnr.example.utils.SignatureUtil;
import com.js.pay.service.chinapnr.example.utils.XMLSecurityProcess;
import com.js.pay.service.chinapnr.example.utils.XMLUtil;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import common.util.httpclient.HttpRequestContext;
import common.util.httpclient.HttpSendResult;
import common.util.httpclient.impl.HttpClientServiceImpl;
import common.util.httpclient.impl.SimpleHttpsClientImpl;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class chinaPNRTest {

    /**
     * 模版文件
     */
    private static String tempaltefile = "request_sell_";

    /**
     * 模版文件配置
     */
    private static Configuration cfg = new Configuration();
    //测试环境
    private static String postUrl = "https://hfgj.chinapnr.com/pay/receivesell.htm";

    public static  void main(String [] args){

        Map<String, Object> parameter = new HashMap<>();

        //商户号
        parameter.put("MERCHANTID","1000605000101");
        //终端号
        parameter.put("TERMINALID","0010001");
        //产品类型
        parameter.put("PRODUCTTYPE","JH");
        //接口版本
        parameter.put("VERSION","1.0");
        //交易类别
        parameter.put("TRXTYPE","100040");

        parameter.put("BATCH_NO","10001022246");
        parameter.put("REQTIME","20190612154301");
        parameter.put("PAY_CUR","CNY");
        parameter.put("PAY_TCNT", "1");
        parameter.put("PAY_TAMT","10");

        parameter.put("PURPOSE","test");
        parameter.put("EXT1","EXT1");
        parameter.put("EXT2","EXT1");
        parameter.put("RESULT_URL","http://192.168.1.111:8081/ChinapnrDemo/sell/result.htm");
        parameter.put("DETAILS","R1022|10|CMB|H|30000100|王文斌|00|4682037906128888|江苏省|南京市|招行银行南京分行城东支行|Test|T10004|ext1|ext2");

        chinaPNRTest test = new chinaPNRTest();
        String requestXml = test.transferToXML(parameter, parameter.get("TRXTYPE").toString());
        System.out.println(requestXml);

        Document doc = XMLUtil.str2Doc(requestXml,"utf-8");

        String merchantAcctId = parameter.get("MERCHANTID").toString();
        String envType = "stage2";
        String password = "123456";
        String aliasName = "test-alias";
        System.out.println("doc="+doc.toString());
        System.out.println(merchantAcctId);
        System.out.println(envType);
        System.out.println(password);
        System.out.println(aliasName);
        try {
            SignatureUtil.xmlSignature(doc, envType, merchantAcctId.substring(0,merchantAcctId.length()-2),
                    password, aliasName);
        } catch (Exception e) {
            e.printStackTrace();
        }

        requestXml = XMLUtil.doc2Str(doc,"utf-8");
        System.out.println("requestXml:" + requestXml);

        HttpRequestContext context = new HttpRequestContext();
        context.setUrl(postUrl);
        context.setHttpMethod(HttpRequestContext.POST_METHOD);
        context.setResponseCharset("utf-8");
        context.setRequestCharset("utf-8");
        context.setXml(requestXml);
        HttpSendResult result = null;
        HttpClientServiceImpl httpClient = new HttpClientServiceImpl();
        SimpleHttpsClientImpl shci = new SimpleHttpsClientImpl();
        httpClient.setHttpsClient(shci);
        try {
            result = httpClient.sendRequest(context);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        String respTxt = null;
        if (null ==  result) {
            respTxt = "网关系统异常------";
        }else{
            System.out.println("result:" + result.getResponseBody());


            if(result.getStatus() == 200){
                respTxt = result.getResponseBody();
            }else{
                respTxt = "网关系统异常,状态码[" + result.getStatus() + "]";
            }
        }

        Document resDoc = null;
        try{
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new ByteArrayInputStream(respTxt.getBytes("UTF-8"))));
            // 解析XML文档
            resDoc = parser.getDocument();

        }catch (Exception e){

        }

//        Document resDoc = StringTOXml(respTxt);


        boolean falg = false;
        try{
            falg = XMLSecurityProcess.veryfySignature(resDoc);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        if (falg){
            System.out.println("返回结果验签成功");
        }else{
            System.out.println("返回结果验签失败");
        }
        String nodePath = "/RESPONSE/PARAMS/STATUS";
        String nodeValue = getNodeValue(resDoc, nodePath);
        System.out.println("nodeValue= " + nodeValue);

    }

    public  String transferToXML(Map params, String TRXTYPE) {
        Template template = null;
        try {
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            cfg.setDefaultEncoding( "UTF-8" );
            cfg.setTemplateUpdateDelay(0);
            cfg.setCacheStorage(new freemarker.cache.MruCacheStorage(5, 5));
            //cfg.setTemplateLoader(new ClassTemplateLoader(
                   // RequestHppController.class, "/ftl"));
            cfg.setDirectoryForTemplateLoading(new File("d:/ftl"));

            template = cfg.getTemplate(tempaltefile + TRXTYPE + ".ftl");
            StringWriter result = new StringWriter();
            template.process(params, result);


            return result.toString();

        } catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }

    }

    public static Document StringTOXml(String str) {

        StringBuilder sXML = new StringBuilder();
        sXML.append(str);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            InputStream is = new ByteArrayInputStream(sXML.toString().getBytes("utf-8"));
            doc = dbf.newDocumentBuilder().parse(is);
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    /**
     *
     * @param document
     * @return 某个节点的值 前提是需要知道xml格式，知道需要取的节点相对根节点所在位置
     */
    public static String getNodeValue(Document document, String nodePaht) {
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath path = xpfactory.newXPath();
        String servInitrBrch = "";
        try {
            servInitrBrch = path.evaluate(nodePaht, document);
        } catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return servInitrBrch;
    }
}
