package com.js.pay.service.chinapnr.example;

import com.js.pay.service.chinapnr.example.otherutils.HttpSendResult;
import com.js.pay.service.chinapnr.example.otherutils.SignTool;
import com.js.pay.service.chinapnr.example.otherutils.SimpleHttpsClient;
import sun.misc.BASE64Encoder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

public class EnterpriseOpenAccount {

    public static void main(String [] args){

        Map<String, String> parameter = new HashMap<>();


        //接口版本
        parameter.put("version", "1");
        parameter.put("signType", "4");

        //商户号
        parameter.put("merchantAcctId", "1000605000101");
        parameter.put("requestTime", "20190614155601");

        parameter.put("requestId", "m123010121111295");
        //用户平台ID
        parameter.put("platformUserId", "1234567905");
        parameter.put("platformRegTime", "20190614155601");
        parameter.put("name", "王文斌");
        parameter.put("type", "2"); //企业类型 1-个体工商户 2-企业
        parameter.put("legalPerson", "王文斌"); //法人姓名
        parameter.put("legalCertType", "00"); //法人证件类型
        parameter.put("legalCertId", "411081199004235955"); //法人证件号
        parameter.put("legalCertExpDateEnd", "20350606"); //法人证件时效日期
        parameter.put("contactCertExpDateEnd", "20990101"); //联系人证件失效日期
        parameter.put("address", "北京通州");//企业地址
        parameter.put("phone", "13311288001"); //企业电话
        parameter.put("orgCode", "MA6H4JR5-X"); //组织机构代码
        parameter.put("orgExpDateEnd", "20990101"); //组织机构代码失效日期
        parameter.put("bizLicenseCode", "91520382MA6H4JR5XP"); //营业执照号
        parameter.put("bizLicenseExpDateEnd", "20990101"); //营业执照失效日期
        parameter.put("taxRegCode", "105997713880"); //税务登记号
        parameter.put("taxRegExpDateEnd", "20990101");//税务登记证失效日期
        parameter.put("bankCode", "CMBC"); //开户银行
        parameter.put("acctType", "1");//账户类型 1-对公 2-对私
        parameter.put("bankAcct", "4682037906128888");//账号
        parameter.put("acctName", "王文斌");//户名
        parameter.put("province", "北京");//省份
        parameter.put("area", "北京");//地区
        parameter.put("bankBranch", "北京通州招商银行支行");//支行名称
        parameter.put("uniteBankCode", "4682037906128888");//收款行联行号
        parameter.put("legalCertPhotoCopyF", getImageStr("d:/sfz/sfz_z.jpg"));  //法人证件的影印件正面
        parameter.put("legalCertPhotoCopyB", getImageStr("d:/sfz/sfz_f.jpg")); //法人证件的影印件反面
        parameter.put("bizLicensePhotoCopy", getImageStr("d:/sfz/sfz_f.jpg")); //营业执照影印件
        parameter.put("asyncNoticeFlag", "1"); //是否接收异步通知
        parameter.put("noticeUrl", "http://www.baidu.com"); //后台通知地址

        parameter.put("orgPhotoCopy", getImageStr("d:/sfz/sfz_f.jpg")); //组织机构代码证影印件
        parameter.put("taxRegPhotoCopy", getImageStr("d:/sfz/sfz_f.jpg"));//税务登记证影印件
        parameter.put("openLicensePhotoCopy", getImageStr("d:/sfz/sfz_f.jpg"));//开户许可证影印件

        Map<String,String> signMsgValMap = new HashMap<>();
        signMsgValMap.put("version", parameter.get("version"));
        signMsgValMap.put("signType", parameter.get("signType"));
        signMsgValMap.put("requestId", parameter.get("requestId"));
        signMsgValMap.put("requestTime", parameter.get("requestTime"));
        signMsgValMap.put("merchantAcctId", parameter.get("merchantAcctId"));
        signMsgValMap.put("platformUserId", parameter.get("platformUserId"));
        signMsgValMap.put("platformRegTime", parameter.get("platformRegTime"));
        signMsgValMap.put("name", parameter.get("name"));
//        signMsgValMap.put("shortName", "");
        signMsgValMap.put("type", parameter.get("type"));
        signMsgValMap.put("legalPerson", parameter.get("legalPerson"));
        signMsgValMap.put("legalCertType", parameter.get("legalCertType"));
        signMsgValMap.put("legalCertId", parameter.get("legalCertId"));
//        signMsgValMap.put("legalCertExpDate", parameter.get("legalCertExpDateEnd"));
//        signMsgValMap.put("legalMobile", "");//
//        signMsgValMap.put("contactName", "");//
//        signMsgValMap.put("contactCertType", "");//
//        signMsgValMap.put("contactCertId", "");//
//        signMsgValMap.put("contactCertExpDate", parameter.get("contactCertExpDateEnd"));
//        signMsgValMap.put("contactMobile", "");//
//        signMsgValMap.put("contactEmail", parameter.get("contactEmail"));
        signMsgValMap.put("address", parameter.get("address"));
        signMsgValMap.put("phone", parameter.get("phone"));
        signMsgValMap.put("orgCode", parameter.get("orgCode"));
//        signMsgValMap.put("orgExpDate", parameter.get("orgExpDateEnd"));
        signMsgValMap.put("bizLicenseCode", parameter.get("bizLicenseCode"));
//        signMsgValMap.put("bizLicenseExpDate", parameter.get("bizLicenseExpDateEnd"));
        signMsgValMap.put("taxRegCode", parameter.get("taxRegCode"));
//        signMsgValMap.put("taxRegExpDate", parameter.get("taxRegExpDateEnd"));
        signMsgValMap.put("bankCode", parameter.get("bankCode"));
        signMsgValMap.put("acctType", parameter.get("acctType"));
        signMsgValMap.put("bankAcct", parameter.get("bankAcct"));
        signMsgValMap.put("acctName", parameter.get("acctName"));
        signMsgValMap.put("province", parameter.get("province"));
        signMsgValMap.put("area", parameter.get("area"));
        signMsgValMap.put("bankBranch", parameter.get("bankBranch"));
        signMsgValMap.put("uniteBankCode", parameter.get("uniteBankCode"));

        String signMsgVal = createLinkString(signMsgValMap);
        System.out.println("签名：" + signMsgVal);
        //商户会员号，不可空。
        String merchantAcctId = parameter.get("merchantAcctId").toString();
        //String memberCode = "10006050001";
        //1001215986901
        // String merchantAcctId = memberCode + "01";
        //证书密码,不可空。
        String keyPass = "123456";
        //证书名
        String aliasName = "test-alias";
        SignTool pki = new SignTool(merchantAcctId.substring(0, merchantAcctId.length() - 2), "", keyPass, aliasName);
        String signMsg = pki.signMsg(signMsgVal);
        parameter.put("signMsg", signMsg);

        SimpleHttpsClient httpClient = new SimpleHttpsClient();
        String postUrl = "https://hfgj.chinapnr.com/mcs/enterpriseReg.htm";
        HttpSendResult result = null;
        System.out.println("map=" + parameter);
        try {
            result = httpClient.postRequest(postUrl,
                    parameter, 30000);
        } catch (Exception e) {
            // TODO Auto-generated catch block
        }
        System.out.println("result:" + result.getResponseBody());
    }

    /**
     * @return
     * @Description: 根据图片地址转换为base64编码字符串
     * @Author:
     * @CreateTime:
     */
    public static String getImageStr(String imgFile) {
        InputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = new FileInputStream(imgFile);
            data = new byte[inputStream.available()];
            inputStream.read(data);
            inputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        // 加密
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static String appendParam(String returns, String paramId, String paramValue) {
        if (returns != "") {
            if (paramValue != "") {

                returns += "&" + paramId + "=" + paramValue;
            }

        } else {

            if (paramValue != "") {
                returns = paramId + "=" + paramValue;
            }
        }

        return returns;
    }


    /**
     * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
     *
     * @param params 需要排序并参与字符拼接的参数组
     * @return 拼接后字符串
     */
    public static String createLinkString(Map<String, String> params) {

        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {// 拼接时，不包括最后一个&字符
                prestr = prestr + key + "=" + value;
            } else {
                prestr = prestr + key + "=" + value + "&";
            }
        }
        return prestr;
    }

    public static Map<String,String> getCallbackMap(String dataReceived){
        Map<String,String> map = new HashMap();
        String[] param =  dataReceived.split("&");
        for(String keyvalue:param){
            String[] pair = keyvalue.split("=");
            if(pair.length==2){
                map.put(pair[0], pair[1]);
            }
        }
        return map;
    }
}

















