package com.js.api.jspay.service;

import com.alibaba.fastjson.JSONObject;
import com.js.common.model.req.JsKycChargeReq;
import com.js.common.model.vo.JsKycChargeVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 用户汇率操作接口
 * @Author: liuh
 * @Create: 2019-06-23
 **/
@Path("apiKycBank")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsKycChargeService {
    /**
     * 获取汇率表用户汇率信息
     */
    @GET
    @Path("findKycChargeInfo")
    JsKycChargeVO findKycChargeInfo(JsKycChargeReq jsKycChargeReq);

    /**
     * @Description: 获取汇率表用户所有汇率信息
     * @Author: liuh
     * @Create: 2019-08-14
     **/
    @GET
    @Path("findKycChargeList")
    JSONObject findKycChargeList(JsKycChargeReq jsKycChargeReq);

    /**
     * @Description: 新增或者编辑汇率信息
     * @Author: liuh
     * @Create: 2019-08-15
     **/
    @POST
    @Path("operateKycChargeInfo")
    ResponseMessage operateKycChargeInfo(JsKycChargeReq jsKycChargeReq);
}
