package com.js.api.jspay.service.chinapnr;

import com.js.common.model.req.ChinaPNRSubstituteQueryReq;
import com.js.common.model.req.ChinaPNRSubstituteReq;
import com.js.common.model.vo.common.ResponseMessage;
import org.w3c.dom.Document;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.Map;

/**
 * @Description: 汇付国际代发
 * @Author: zhouyongsheng
 * @Create: 2019-06-10
 **/
@Path("chinaPNRPaySubstitute")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ChinaPNRPaySubstituteService {

    /**
     * 客户提现
     * @param chinaPNRSubstituteReq
     * @return
     */
    @GET
    @Path("newSubstituteTrade")
    ResponseMessage newSubstituteTrade(ChinaPNRSubstituteReq chinaPNRSubstituteReq);

    /**
     * 客户还款，还款服务费,汇差 ，提现服务费交易
     * @param chinaPNRSubstituteReq
     * @return
     */
    @GET
    @Path("oldSubstituteTrade")
    ResponseMessage oldSubstituteTrade(ChinaPNRSubstituteReq chinaPNRSubstituteReq);


    /**
     * 客户还款汇差等代发通知
     * @param wholeStr
     * @return
     */
    @GET
    @Path("oldCallbackSubstitute")
    ResponseMessage oldCallbackSubstitute(String wholeStr);

    /**
     * 客户提现代发通知
     * @param resMap
     * @return
     */
    @GET
    @Path("newCallbackSubstitute")
    ResponseMessage newCallbackSubstitute(Map<String, String> resMap);


    /**
     * 客户提现查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @GET
    @Path("queryNewSubstitute")
    ResponseMessage queryNewSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq);

    /**
     * 客户还款，还款服务费,汇差 ，提现服务费交易查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    @GET
    @Path("queryOldSubstitute")
    ResponseMessage queryOldSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq);
}
