package com.js.api.jspay.service;

import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.WaiHuiVO;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 外汇交互
 * @Author: liuh
 * @Create: 2019-08-29
 **/
@Path("apiWaiHuiService")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiWaiHuiService {
    /**
     * @Author liuh
     * @Description: 根据币种获取外汇汇率信息
     * @Date 2019/8/30
     **/
    @GET
    @Path("getWaiHuiInfo")
    WaiHuiVO getWaiHuiInfo(String currency);

    /**
     * @Author liuh
     * @Description: 存储生效外汇查询信息
     * @Date 2019/8/30
     **/
    @GET
    @Path("saveWaiHuiInfo")
    int saveWaiHuiInfo(WaiHuiVO waiHuiVO, KycNaturalVO kycNaturalVO);
}
