package com.js.api.jspay.service;


import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.vo.JsPayUserStationInfoVO;
import com.js.common.model.vo.JsPayVatPaymentInfoVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 用户VAT缴税机构关系
 */
@Path("apiJsPayUserStationInfoService")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPayUserStationInfoService {

    /**
     * 查询VAT缴税机构状态
     */
    @GET
    @Path("queryVatStationStatus")
    String queryVatStationStatus(String taxStationId);

    /**
     * 查询VAT缴税机构是否已保存
     */
    @GET
    @Path("queryVatStationInfo")
    JsPayUserStationInfoVO queryVatStationInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq);
    /**
     * 新增用户VAT缴税机构关系
     */
    @POST
    @Path("addPayUserStationInfo")
    @Transactional
    ResponseMessage addPayUserStationInfo(JsPayUserStationInfoVO jsPayUserStationInfoVO);

}
