package com.js.api.jspay.service.chinapnr;

import com.js.common.model.req.ChinaPNRTransactionDetailsReq;
import com.js.common.model.req.ChinaPNRTransactionReq;
import com.js.common.model.vo.common.ResponseMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.Date;

/**
 * 汇付国际交易明细案
 *
 * @author: liutianyu
 * @date: 2019-07-01
 **/
@Path("chinaPNRPayTransactionDetails")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Component
public interface ChinaPNRTransactionDetailsService {

    @POST
    @Path("saveChinaPNRTransactionDetail")
    @Transactional
    ResponseMessage saveChinaPNRTransactionDetail(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq) ;

    /**
     * 提交结汇明细(订单还原)
     *  定时任务 调度
     * @return
     */
    @POST
    @Path("submitTransactionDetails")
    @Transactional
    ResponseMessage submitTransactionDetails() throws Exception ;

    /**
     *  重推结汇明细（对于订单还原有明细记录的，发汇付处理某一天的订单明细）
     * @param dateStr  yyyyMMdd格式
     * @return
     */
    @POST
    @Path("reSubmitTransactionDetailsForDate")
    @Transactional
    ResponseMessage reSubmitTransactionDetailsForDate(String dateStr) throws Exception ;

    /**
     * 重推结汇明细
     *  （对于订单还原有明细记录的，后台管理人员页面手工操作，处理）
     * @param transactionId  china_pnr_transaction 主键Id
     * @return
     */
    @POST
    @Path("reSubmitDetailsByTransactionId")
    @Transactional
    ResponseMessage reSubmitDetailsByTransactionId(String transactionId) throws Exception ;

    /**
     * 重推结汇明细(根据锁汇后saveChinaPNRTransactionDetail() 方法 失败没有入订单还原明细表的数据 )
     * @param dateStr  yyyyMMdd格式
     * @return
     */
    @POST
    @Path("reSaveTransactionDetailAndSumbit")
    @Transactional
    ResponseMessage reSaveTransactionDetailAndSumbit(String dateStr) throws Exception ;

    @POST
    @Path("transactionDetailsCallback")
    ResponseMessage transactionDetailsCallback(String responseStr);

//    @POST
//    @Path("submitTransactionDetailsTest2")
//    ResponseMessage submitTransactionDetailsTest2();

}
