package com.js.api.jspay.service;

import com.js.common.model.req.KycSecurityReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 密保接口
 * @Author: liuh
 * @Create: 2019-07-8
 **/
@Path("apiKycSecurity")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycSecurityService {
    /**
     * @author:liuh
     * @Descripiton: 设置密保保存
     * @Date 2019/07/8
     */
    @POST
    @Path("saveSecurityByKyc")
    ResponseMessage saveSecurityByKyc(KycSecurityReq kycSecurityReq, KycNaturalVO kycNaturalVO);

    /**
     * @author:liuh
     * @Descripiton: 查询密保
     * @Date 2019/07/8
     */
    @POST
    @Path("findSecurityByKyc")
    ResponseMessage findSecurityByKyc(KycNaturalVO kycNaturalVO);
}
