package com.js.api.jspay.service;

import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.req.KycBankReq;
import com.js.common.model.req.KycCheckBankReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 用户绑定银行卡
 * @Author: liuty
 * @Create: 2019-05-25
 **/
@Path("apiKycBank")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycBankService {

    /**
     * @Description: 增加绑定银行卡
     * @Author: liuh
     * @Create: 2019-06-22
     **/
    @POST
    @Path("addBankCard")
    @Transactional
    ResponseMessage addBankCard(KycBankReq kycBankReq, KycNaturalVO kycNaturalVO);

    /**
     * 解除绑定的银行卡
     */
    @DELETE
    @Path("disableBankCard")
    ResponseMessage disableBankCard(String bankId,KycNaturalVO kycNaturalVO);

    /**
     * 银行卡详情
     */
    @GET
    @Path("getBankCard/{id}")
    ResponseMessage getBankCard(@PathParam("id") String id);

    /**
     * 获取银行卡列表(js-manager)
     *
     * @author liutianyu
     */
    @GET
    @Path("getBankCardList")
    String getBankCardList(KycBankCardReq kycBankCardReq);

    /**
     * 获取银行卡列表
     */
    @GET
    @Path("getKycBankList")
    ResponseMessage getKycBankList(KycBankCardReq kycBankCardReq);

    /**
     * 获取银行卡省份信息
     */
    @GET
    @Path("getProvence")
    ResponseMessage getProvence();
    /**
     * 获取银行卡市区信息
     */
    @GET
    @Path("getCity/{provinceCode}")
    ResponseMessage getCity(@PathParam("provinceCode") String provinceCode);

    /**
     * 银行卡二三四要素验证
     */
    @POST
    @Path("checkBank")
    ResponseMessage checkBank(@RequestBody KycCheckBankReq kycCheckBankReq);
}
