package com.js.api.jspay.service;

import com.js.common.model.req.KycCertiHKCompanyReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 香港企业操作服务接口
 * @Author: liuh
 * @Create: 2019-05-31
 **/
@Path("apiKycCertiHKCompany")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycCertiHKCompanyService {

    /**
     * @Author liuh
     * @Description 实名认证-香港企业-保存
     * @Date 2019/5/31
     **/
    @POST
    @Path("certiHKCompany")
    @Transactional
    ResponseMessage certiHKCompanyAdd(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @param companyRegisteredCertificateNo-公司注册证书编号
     *@Description 校验香港个企业是否存在
     * @Date 2019/6/5
     */
    @GET
    @Path("verifyCertiHKCompanyExists")
    boolean verifyCertiHKCompanyExists(String companyRegisteredCertificateNo);

    /**
     * @Author liuh
     * @Description 实名认证-香港企业-编辑
     * @Date 2019/8/5
     **/
    @PUT
    @Path("certiHKCompanyUpdate")
    @Transactional
    ResponseMessage certiHKCompanyUpdate(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO);
}
