package com.js.api.jspay.service;

import com.js.common.enums.GenerateFileType;
import com.js.common.model.req.GenerateFileRecordReq;
import com.js.common.model.vo.FileVo;
import com.js.common.model.vo.GenerateFileRecordVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 文件生成记录接口
 * @Author: liuh
 * @Create: 2019-07-15
 **/
@Path("apiGenerateFileRecord")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiGenerateFileRecordService {
    /**
     * @Author liuh
     * @Description 文件生成记录表查询
     * @Date 2019/7/15
     **/
    @GET
    @Path("generateFileRecordList")
    ResponseMessage generateFileRecordList(GenerateFileType generateFileType,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 添加文件生成记录
     * @Date 2019/7/15
     **/
    @POST
    @Path("generateFileRecordAdd")
    ResponseMessage generateFileRecordAdd(GenerateFileRecordReq generateFileRecordReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 更新文件生成记录
     * @Date 2019/7/22
     **/
    @PUT
    @Path("generateFileRecordUpdate")
    ResponseMessage generateFileRecordUpdate(FileVo fileVo,GenerateFileRecordVO generateFileRecordVO, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 根据ID查询信息
     * @Date 2019/7/22
     **/
    @POST
    @Path("findGenerateFileRecordById")
    GenerateFileRecordVO findGenerateFileRecordById(GenerateFileRecordReq generateFileRecordReq);
}
