package com.js.api.jspay.service;

import com.js.common.enums.CertiStatusEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.Valid;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 与寻汇用户操作相关交互接口
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Path("apiSunRateRegister")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiSunrateRegisterService {
    /**
     * @Author liuh
     * @Description 寻汇注册用户-大陆个人
     * @Date 2019/5/20
     **/
    @POST
    @Path("xhRegisterMainLandPersonal")
    ResponseMessage xhRegister(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 寻汇注册用户-大陆企业
     * @Date 2019/5/25
     **/
    @POST
    @Path("xhRegisterMainLandCompany")
    ResponseMessage xhRegister(CertiMainLandCompanyReq certiMainLandCompanyReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 寻汇注册用户-香港个人
     * @Date 2019/5/31
     **/
    @POST
    @Path("xhRegisterHKPersonal")
    ResponseMessage xhRegister(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 寻汇注册用户-香港企业
     * @Date 2019/5/31
     **/
    @POST
    @Path("xhRegisterHKCompany")
    ResponseMessage xhRegister(KycCertiHKCompanyReq kycCertiHKCompanyReq, KycNaturalVO kycNaturalVO);

    /**
     * @author:liuh
     * @Descripiton: 寻汇注册用户接口
     * @Date 2019/05/28
     */
    @POST
    @Path("sendRegisterInfoToXh")
    ResponseMessage sendRegisterInfoToXh(String browserIP,String kycCertiId, @Valid KycSunrateRegisterReq kycSunrateRegisterReq,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 寻汇 -> 合作方 开户结果通知 接口
     * @Date 2019/5/21
     **/
    @POST
    @Path("registerCreateNotice")
    @Transactional
    ResponseMessage registerCreateNotice(KycSunrateRegisterNoticeReq kycSunrateRegisterNoticeReq);

    /**
     * @Author liuh
     * @Description 开户结果查询 接口
     * @Date 2019/6/4
     **/
    @POST
    @Path("queryXhAccount")
    ResponseMessage queryXhAccount(String browserIP, String orgCode);
}
