package com.js.api.jspay.service;

import com.js.common.model.req.KycCertiHKPersonalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 香港个人操作服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Path("apiKycCertiHKPersonal")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycCertiHKPersonalService {

    /**
     * @Author liuh
     * @Description 实名认证-香港个人-保存
     * @Date 2019/5/31
     **/
    @POST
    @Path("certiHKPersonal")
    @Transactional
    ResponseMessage certiHKPersonalAdd(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @param certificateNo-证件号码
     *@Description 校验香港个人是否存在
     * @Date 2019/6/5
     */
    @GET
    @Path("verifyCertiHKPersonalExists")
    boolean verifyCertiHKPersonalExists(String certificateNo);

    /**
     * @Author liuh
     * @Description 实名认证-香港个人-编辑
     * @Date 2019/8/5
     **/
    @PUT
    @Path("certiHKPersonalUpdate")
    @Transactional
    ResponseMessage certiHKPersonalUpdate(KycCertiHKPersonalReq kycCertiHKPersonalReq, KycNaturalVO kycNaturalVO);
}
