package com.js.api.jspay.service;

import com.js.common.model.req.JsSystemHolidayReq;
import com.js.common.model.vo.JsSystemHolidayVO;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 节假日表操作
 * @Author: liuh
 * @Create: 2019-09-03
 **/
@Path("apiJsSystemHolidaysService")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsSystemHolidaysService {
    /**
     * 添加节假日
     * @Author:liuh
     * Create:2019-09-03
     */
    @POST
    @Path("addJsSystemHolidays")
    int addJsSystemHolidays(JsSystemHolidayReq jsSystemHolidayReq);

    /**
     * @Author liuh
     * @Description 节假日数据列表
     * @Date 2019/9/3
     **/
    @GET
    @Path("getJsSystemHolidayList")
    String getJsSystemHolidayList(JsSystemHolidayReq jsSystemHolidayReq);

    /**
     * @Author liuh
     * @Description 查询最后一条数据
     * @Date 2019/9/3
     **/
    @GET
    @Path("getLastHoliday")
    JsSystemHolidayVO getLastHoliday();

    /**
     * 修改日期类型
     * @Author:liuh
     * Create:2019-09-03
     */
    @POST
    @Path("changeHolType")
    int changeHolType(JsSystemHolidayReq jsSystemHolidayReq);
}
