package com.js.api.jspay.service;

import com.js.common.enums.EmailRemindTypeEnum;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 邮箱服务实现
 * @Author: liuh
 * @Create: 2019-07-14
 **/
@Path("apiIMailService")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiIMailService {
    /**
     * 发送文本邮件
     * @Author:liuh
     * Create:2019-07-14
     */
    @POST
    @Path("sendSimpleMail")
    void sendSimpleMail(String to, String subject, String content);

    /**
     * 根据预制邮件地址发送提醒邮件
     * @Author:liuh
     * Create:2019-06-15
     * subject : 标题
     * content : 邮件内容
     */
    @POST
    @Path("sendRemindEmail")
    void sendRemindEmail(String subject, String content, EmailRemindTypeEnum emailRemindTypeEnum);
    /**
     * 发送文本邮件
     * @Author:liuh
     * Create:2019-07-14
     */
    @POST
    @Path("sendSimpleMailcc")
    void sendSimpleMail(String to, String subject, String content, String... cc);
}
