package com.js.api.jspay.service;

import com.js.common.model.req.KycSunrateStoreReq;
import com.js.common.model.req.SunrateStoreAuditReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateStoreVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.validation.Valid;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 寻汇店铺操作接口
 * @Author: liuh
 * @Create: 2019-06-10
 **/
@Path("apiKycSunRateStore")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycSunrateStoreService {
    /**
     * @author:liuh
     * @Descripiton: 寻汇添加店铺接口
     * @Date 2019/05/29
     */
    @POST
    @Path("sendSunrateStoreInfoToXh")
    ResponseMessage sendSunrateStoreInfoToXh(String browserIP, @Valid KycSunrateStoreReq kycSunrateStoreReq);

    /**
     * @Author liuh
     * @Description 保存请求寻汇添加店铺信息
     * @Date 2019/6/10
     **/
    @POST
    @Path("addSunrateStore")
    ResponseMessage addSunrateStore(KycSunrateStoreReq kycSunrateStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Description: 寻汇 -> 合作方 审核店铺通知 接口
     * @Author liuh
     * @Date 2019/6/10
     **/
    @POST
    @Path("storeAuditNotice")
    ResponseMessage storeAuditNotice(SunrateStoreAuditReq sunrateStoreAuditReq);

    /**
     * @Description: 5.5查询店铺（合作方 -> 寻汇）
     * @Author liuh
     * @Date 2019/6/10
     **/
    @GET
    @Path("sunrateStoreList")
    ResponseMessage sunrateStoreList(String orgCode,String browserIP);

    /**
     * @Description: 查询已经请求寻汇完成的店铺信息
     * @Author liuh
     * @Date 2019/6/19
     **/
    @GET
    @Path("findSunrateStoreInfo")
    KycSunrateStoreVO findSunrateStoreInfo(String kycStoreId,String kycSunrateStoreId,String kycNaturalId);

    /**
     * @Description: 5.2 修改店铺（合作方 -> 寻汇)
     * @Author liuh
     * @Date 2019/8/26
     **/
    @PUT
    @Path("sendEditStoreInfoToXh")
    ResponseMessage sendEditStoreInfoToXh(KycSunrateStoreReq kycSunrateStoreReq);

    /**
     * @Author liuh
     * @Description 更新寻汇店铺表信息
     * @Date 2019/8/26
     **/
    @POST
    @Path("updateSunrateStore")
    ResponseMessage updateSunrateStore(KycSunrateStoreReq kycSunrateStoreReq, KycNaturalVO kycNaturalVO);
}
