package com.js.api.jspay.service;

import com.js.common.model.req.KycShowStoreReq;
import com.js.common.model.req.KycStoreEditReq;
import com.js.common.model.req.KycStoreReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycStoreVO;
import com.js.common.model.vo.KycSunrateStoreVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 申请境外虚拟户-店铺记录服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Path("apiKycStore")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycStoreService {

    /**
     * @Author liuh
     * @Description 申请境外虚拟户-添加店铺
     * @Date 2019/5/21
     **/
    @POST
    @Path("kycSore")
    @Transactional
    ResponseMessage addStore(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description js店铺列表
     * @Date 2019/5/23
     **/
    @GET
    @Path("storeList")
    ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liwm
     * @Description js店铺列表
     * @Date 2019/7/17
     **/
    @GET
    @Path("queryStoreListByCurr")
    ResponseMessage queryStoreListByCurr(KycShowStoreReq kycShowStoreReq);
    /**
     * @Author liuh
     * @Description js店铺列表,无分页
     * @Date 2019/7/10
     **/
    @GET
    @Path("storeListNoPage")
    ResponseMessage storeListNoPage(KycStoreReq kycStoreReq,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取各个站点申请账户数量
     * @Date 2019/5/29
     **/
    @GET
    @Path("findApplyCountNum")
    ResponseMessage findApplyCountNum(String browserIP,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 根据主键ID查询kyc店铺信息
     * @Date 2019/6/19
     **/
    @GET
    @Path("findKycStoreByPrimaryKey")
    KycStoreVO findKycStoreByPrimaryKey(String kycStoreId, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 编辑保存店铺信息
     * @Date 2019/6/25
     **/
    @PUT
    @Path("editStore")
    ResponseMessage editStore(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO, KycSunrateStoreVO sunrateStoreInfoVO);

    /**
     * @Author liuh
     * @Description 编辑保存店铺名称
     * @Date 2019/8/29
     **/
    @PUT
    @Path("editStoreName")
    ResponseMessage editStoreName(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 个人中心-我的账户-提现手续费费率
     * @Date 2019/7/5
     **/
    @GET
    @Path("showWithdrawCharge")
    ResponseMessage showWithdrawCharge(KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取已申请的站点
     * @Date 2019/7/11
     **/
    @GET
    @Path("findApplySite")
    ResponseMessage findApplySite(KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 编辑店铺信息
     * @Date 2019/8/26
     **/
    @PUT
    @Path("editStoreProcessStatus")
    ResponseMessage editStoreProcessStatus(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 提供给运营平台js店铺列表
     * @Date 2019/8/26
     **/
    @GET
    @Path("storeListYY")
    String storeListYY(KycStoreReq kycStoreReq);
}
