package com.js.api.jspay.service;

import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.JsPayVatPaymentRcvListReq;
import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Path("apiJsPayVatPaymentInfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPayVatPaymentInfoService {

    /**
     * 查询VAT缴税的收款人列表
     */
    @GET
    @Path("queryRcvList")
    ResponseMessage queryRcvList(String kycNaturalId);

    @GET
    @Path("queryVatList")
    ResponseMessage queryVatList(String str);

    /**
     * 根据受益人ID查询JsPayVatPaymentInfoReq 集合信息
     * @param beneficiaryId
     * @return
     */
    @POST
    @Path("queryJsPayVatPaymentInfoReqList")
    ResponseMessage queryJsPayVatPaymentInfoReqList(String beneficiaryId);

    /**
     * 新增VAT缴税记录
     */
    @POST
    @Path("addPayVatPaymentInfo")
    @Transactional
    ResponseMessage addPayVatPaymentInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq);

    /**
     *  vat缴税记录到DB
     * @param jsPayVatPaymentInfoReq
     * @return
     */
    @POST
    @Path("addVatPayTrade")
    @Transactional
    ResponseMessage addVatPayTrade(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, KycNaturalVO kycNaturalVO);

    /**
     *  vat缴税信息更新
     * @param jsPayVatPaymentInfoReq
     * @param id
     * @return
     */
    @POST
    @Path("updatePayVatPaymentInfo")
    @Transactional
    ResponseMessage updatePayVatPaymentInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq,String id);

    /**
     *  vat缴税状态更新根据id
     * @param ids
     * @param status
     * @return
     */
    @POST
    @Path("updateStatusById")
    @Transactional
    ResponseMessage updateStatusById(List<String> ids, String status);

    /**
     * 受益人审核结果通知，VAT缴税处理
     * @param beneficiayId
     * @return
     */
    @POST
    @Path("updatePayVatPaymentInfo")
    @Transactional
    ResponseMessage beneficiayAuditNotice(String beneficiayId);

    /**
     *
     * 受益人审核回调 处理
     * @param jsPayVatPaymentInfoReq
     * @param kycNaturalVO
     * @return
     */
    @POST
    @Path("beneficiayAuditNoticeVatPayTrade")
    ResponseMessage beneficiayAuditNoticeVatPayTrade(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, KycNaturalVO kycNaturalVO);
}
