package com.js.api.jspay.service.chinapnr;

import com.js.common.model.req.ChinaPNRTransactionDetailsReq;
import com.js.common.model.req.ChinaPNRTransactionReq;
import com.js.common.model.vo.common.ResponseMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 汇付国际交易明细案
 *
 * @author: liutianyu
 * @date: 2019-07-01
 **/
@Path("chinaPNRPayTransactionDetails")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
@Component
public interface ChinaPNRTransactionDetailsService {

    @POST
    @Path("saveChinaPNRTransactionDetail")
    @Transactional
    ResponseMessage saveChinaPNRTransactionDetail(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq) ;

    /**
     * 提交结汇明细(订单还原)
     *
     * @return
     */
    @POST
    @Path("submitTransactionDetails")
    @Transactional
    ResponseMessage submitTransactionDetails() throws Exception ;

    /**
     * 重推结汇明细
     *
     * @param chinaPNRTransactionDetailsReq
     * @return
     */
    @POST
    @Path("reSubmitTransactionDetails")
    @Transactional
    ResponseMessage reSubmitTransactionDetails(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq) throws Exception ;

    @POST
    @Path("transactionDetailsCallback")
    ResponseMessage transactionDetailsCallback(String responseStr);

}
