package com.js.api.jspay.service;

import com.js.common.enums.BeneficiaryTypeEnum;
import com.js.common.model.req.KycSunrateBeneficiaryReq;
import com.js.common.model.req.SunrateBeneficiaryAuditReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycSunrateBeneficiaryVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * @Description: 寻汇-受益人交互接口
 * @Author: liuh
 * @Create: 2019-05-30
 **/
@Path("apiSunRateBeneficiary")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiSunrateBeneficiaryService {
    /**
     * @Author liuh
     * @Description 4.1添加受益人（单个）（合作方 -> 寻汇）
     * @Date 2019/5/29
     **/
    @POST
    @Path("beneficiaryCreate")
    ResponseMessage beneficiaryCreate(@Valid KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 4.2修改受益人（单个）（合作方 -> 寻汇）  如果受益人状态为“1”审核通过的话，不允许修改
     * @Date 2019/5/29
     **/
    @PUT
    @Path("beneficiaryModify")
    ResponseMessage beneficiaryModify(@Valid KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 4.4查询受益人（列表）（合作方 -> 寻汇）
     * @Date 2019/5/30
     **/
    @GET
    @Path("beneficiaryList")
    ResponseMessage beneficiaryList(@NotBlank(message = "受益人编号") String orgCode,@NotBlank(message = "浏览器IP不能为空") String browserIP);

    /**
     * @Description: 寻汇 -> 合作方 受益人审核结果通知 接口
     * @Author liuh
     * @Date 2019/6/10
     **/
    ResponseMessage beneficiayAuditNotice(SunrateBeneficiaryAuditReq sunrateStoreAuditReq);

    /**
     * 根据orgCode查询受益人信息
     * @Author liuh
     * @Date 2019/6/20
     */
    List<KycSunrateBeneficiaryVO> beneficiaryListByOrgCode(String orgCode, BeneficiaryTypeEnum beneficiaryTypeEnum,String cur);

    /**
     * @Author liuh
     * @Description 4.1添加受益人（单个）（合作方 -> 寻汇）
     * @Date 2019/7/14
     **/
    @POST
    @Path("beneficiaryCreateMQ")
    ResponseMessage beneficiaryCreateMQ(KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 查询JS方KYC受益人信息
     * @Date 2019/8/25
     **/
    @GET
    @Path("getKycSunrateBeneficiary")
    String getKycSunrateBeneficiary(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq);
}
