package com.js.api.jspay.service;

import com.js.common.model.req.KycCertiContactsReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: kyc联系人操作管理
 * @Author: liuh
 * @Create: 2019-08-15
 **/
@Path("apiKycCertiContacts")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycCertiContactsService {

    /**
     * @Author liuh
     * @Description 保存联系人信息
     * @Date 2019/8/15
     **/
    @POST
    @Path("saveKycCertiContacts")
    @Transactional
    ResponseMessage saveKycCertiContacts(KycCertiContactsReq kycCertiContactsReq,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 查询联系人
     * @Date 2019/8/15
     **/
    @GET
    @Path("getKycCertiContacts")
    ResponseMessage getKycCertiContacts(KycCertiContactsReq kycCertiContactsReq);

    /**
     * @Author liuh
     * @Description 更新联系人信息
     * @Date 2019/8/20
     **/
    @PUT
    @Path("updateKycCertiContacts")
    @Transactional
    ResponseMessage updateKycCertiContacts(KycCertiContactsReq kycCertiContactsReq,KycNaturalVO kycNaturalVO);
}
