package com.js.api.jspay.service;

import com.js.common.model.req.JsPayTradeReq;
import com.js.common.model.vo.JsPaySunrateTradeLockPriceVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.validation.Valid;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;

/**
 * @Description: 交易流水操作接口
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Path("apiJsPayTrade")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPayTradeService {
    /**
     * @Author liuh
     * @Description 流水信息入库
     * @Date 2019/6/4
     **/
    @POST
    @Path("jsPayTradeAdd")
    ResponseMessage jsPayTradeAdd(@Valid JsPayTradeReq jsPayTradeReq);

    /**
     * @Author liuh
     * @Description 提现相关流水入库操作
     * @Date 2019/7/1
     **/
    @POST
    @Path("jsPayTradeAdd")
    ResponseMessage jsPayWithdrawTradeAdd(Map<String,Object> paramsMap,List<JsPayTradeReq> jsPayTradeReqList);

    /**
     * @Author liuh
     * @Description 走寻汇提现出账后处理操作
     * @Date 2019/7/21
     **/
    @POST
    @Path("withdrawBySunrateRouteType")
    ResponseMessage withdrawBySunrateRouteType(JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO);
}
