package com.js.api.jspay.service;

import com.js.common.model.req.JsPaySupplierInfoReq;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("apiJsPaySupplierInfoService")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPaySupplierInfoService {
    /**
     * 查询受益人是否存在
     * @param jsPaySupplierInfoReq
     * @return
     */
    @POST
    @Path("queryBeneficiary")
    String queryBeneficiary(JsPaySupplierInfoReq jsPaySupplierInfoReq) ;

    /**
     * 查询供应商 受益人状态
     */
    @GET
    @Path("querySupplierInfoStatus")
    String querySupplierInfoStatus(String beneficiaryId);

    @GET
    @Path("insertPaySupplierInfo")
    @Transactional
    ResponseMessage insertPaySupplierInfo(JsPaySupplierInfoReq jsPaySupplierInfoReq);

    @GET
    @Path("addSupplierPayTrade")
    @Transactional
    public ResponseMessage addSupplierPayTrade(JsPaySupplierInfoReq jsPaySupplierInfoReq, KycNaturalVO kycNaturalVO);
}
