package com.js.api.jspay.service;

import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.JsPaySunrateTradeLockPriceVO;
import com.js.common.model.vo.JsTradeFundVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.Date;
import java.util.List;

/**
 * @Description: 锁汇成交接口
 * @Author: liuh
 * @Create: 2019-06-11
 **/
@Path("apiJsPaySunrateTradeLockPrice")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPaySunrateTradeLockPriceService {
    /**
     * @author:liuh
     * @Descripiton: 8.2锁汇成交（合作方 -> 寻汇）
     * @Date 2019/06/11
     */
    @POST
    @Path("queryPriceTradeOrder")
    ResponseMessage queryPriceTradeOrder(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq);

    /**
     * @Author liuh
     * @Description 提现列表
     * @Date 2019/7/11
     **/
    @GET
    @Path("withdrawList")
    ResponseMessage withdrawList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 提现详情
     * @Date 2019/7/11
     **/
    @GET
    @Path("withdrawDetail")
    ResponseMessage withdrawDetail(TradeTypeEnum tradeType,TradeSubTypeEnum tradeSubType,String batchNo);

    /**
     * @Author liuh
     * @Description 提现详情/还款详情
     * @Date 2019/6/15
     **/
    @GET
    @Path("withdrawAndRefundDetail")
    ResponseMessage withdrawAndRefundDetail(String tradeId);

    /**
     * @Author liuh
     * @Description 根据出账信息查找提交的锁汇交易信息
     * @Date 2019/6/15
     **/
    @GET
    @Path("findTradeLockInfo")
    JsPaySunrateTradeLockPriceVO findTradeLockInfo(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq);

    /**
     * @author:liuh
     * @Descripiton: 8.3市价锁汇成交（合作方 → 寻汇）
     * @Date 2019/06/28
     */
    @POST
    @Path("tradeMarketOrder")
    ResponseMessage tradeMarketOrder(JsPaySunrateTradeMarketOrderReq jsPaySunrateTradeMarketOrderReq,String kycNaturalId,String kycSunrateStoreId,String kycSunrateBankId);

    /**
     * @Description: 资金明细列表
     * @Author liuh
     * @Date 2019/7/11
     **/
    @GET
    @Path("fundDetailList")
    ResponseMessage fundDetailList(JsTradeFundReq jsTradeFundReq, KycNaturalVO kycNaturalVO);

    /**
     * @Description: 资金明细列表无分页模式
     * @Author liuh
     * @Date 2019/7/24
     **/
    @GET
    @Path("fundDetailListNoPage")
    List<JsTradeFundVO> fundDetailListNoPage(JsTradeFundReq jsTradeFundReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 资金明细列表-提现详情
     * @Date 2019/7/11
     **/
    @GET
    @Path("withdrawFundDetail")
    ResponseMessage withdrawFundDetail(TradeTypeEnum tradeType, String id);

    /**
     * @Author liuh
     * @Description 获取生成交易记录提现列表
     * @Date 2019/7/15
     **/
    @GET
    @Path("generateWithdrawList")
    ResponseMessage generateWithdrawList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取锁汇数据
     * @Date 2019/7/21
     **/
    @GET
    @Path("getLockPriceList")
    List<JsPaySunrateTradeLockPriceVO> getLockPriceList();

    /**
     * @Author liuh
     * @Description 更新锁汇表信息
     * @Date 2019/7/30
     **/
    @PUT
    @Path("updateLockPrice")
    int updateLockPrice(JsPaySunrateTradeLockPriceVO jsPaySunrateTradeLockPriceVO);

    /**
     * @Author liwm
     * @Description 获取锁汇 总金额 by Date
     * @Date 2019/8/13
     **/
    @PUT
    @Path("getLockPriceByDate")
    ResponseMessage getLockPriceByDate (Date start, Date end);
}
