package com.js.api.jspay.service;

import com.js.common.model.req.KycHolderCompanyReq;
import com.js.common.model.req.KycStoreReq;
import com.js.common.model.vo.KycHolderVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;
import java.util.Optional;

/**
 * @Description: 持有人（大陆企业，香港企业）操作服务接口
 * @Author: liuh
 * @Create: 2019-05-23
 **/
@Path("apiKycHolder")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycHolderCompanyService {

    /**
     * @Author liuh
     * @Description 根据条件查找持有人信息
     * @Date 2019/5/23
     **/
    @GET
    @Path("holderCompanyList")
    List<KycHolderVO> holderCompanyList(String holderName, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 实名认证-大陆企业-保存
     * @Date 2019/5/24
     **/
    @Transactional
    ResponseMessage holderCompanyAdd(KycHolderCompanyReq kycHolderCompanyReq, KycNaturalVO kycNaturalVO);
}
