package com.js.api.jspay.service;

import com.js.common.model.req.JsPaySysAcctReq;
import com.js.common.model.vo.JsPaySysAcctVO;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * @Description: 平台第三方账户操作接口
 * @Author: liuh
 * @Create: 2019-06-30
 **/
@Path("apiJsPaySysAcct")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPaySysAcctService {
    /**
     * @Author liuh
     * @Description 根据类型获取平台第三方账户列表
     * @Date 2019/6/30
     **/
    @GET
    @Path("findJsPaySysAcctVOList")
    List<JsPaySysAcctVO> findJsPaySysAcctVOList();

    /**
     * @Author liwm
     * @Description 查询人民币受益人相关账户信息
     * @Date 2019/7/17
     **/
    @GET
    @Path("queryBeneficiaryRmbList")
    JsPaySysAcctVO queryBeneficiaryRmbList();

    /**
     * @Author liuh
     * @Description 查找平台三方账户
     * @Date 2019/8/23
     **/
    @GET
    @Path("getJsPaySysAcctList")
    String getJsPaySysAcctList(JsPaySysAcctReq jsPaySysAcctReq);
}
