package com.js.api.jspay.service;

import com.js.common.enums.SiteEnum;
import com.js.common.model.req.ApplyWithdrawReq;
import com.js.common.model.req.JsPaySunrateBankReq;
import com.js.common.model.req.JsPaySunrateBankTradeInReq;
import com.js.common.model.vo.JsPaySunrateBankVO;
import com.js.common.model.vo.KycBankVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * @Description: 寻汇收款虚拟子账户表操作接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Path("apiKycSunRateBank")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPaySunrateBankService {
    /**
     * @Author liuh
     * @Description 寻汇 -> 合作方 虚拟子账户通知 接口
     * @Date 2019/5/21
     **/
    @POST
    @Path("virtualNotice")
    ResponseMessage virtualNotice(JsPaySunrateBankReq jsPaySunrateBankReq);

    /**
     * @Author liuh
     * @Description 更改用户余额
     * @Date 2019/6/11
     **/
    @PUT
    @Path("updateVirtualAmt")
    ResponseMessage updateVirtualAmt(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq,JsPaySunrateBankVO jsPaySunrateBankVO);

    /**
     * @Author liuh
     * @Description 查询虚拟账户信息
     * @Date 2019/6/11
     **/
    @GET
    @Path("findSunrateBankInfo")
    JsPaySunrateBankVO findSunrateBankInfo(JsPaySunrateBankReq jsPaySunrateBankReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 查询可提现账户信息列表
     * @Date 2019/6/19
     **/
    @GET
    @Path("selCanWithdrawAcctList")
    ResponseMessage selCanWithdrawAcctList(SiteEnum siteEnum, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 申请提现接口
     * @Date 2019/6/28
     **/
    ResponseMessage applyWithdraw(ApplyWithdrawReq applyWithdrawReq, KycNaturalVO kycNaturalVO, KycBankVO kycBankVO);

    /**
     * @Author liuh
     * @Description 查询个人名下所有虚拟账户信息
     * @Date 2019/7/10
     **/
    @GET
    @Path("findSunrateBankInfoList")
    ResponseMessage findSunrateBankInfoList(KycNaturalVO kycNaturalVO);
}
