package com.js.api.jspay.service;

import com.js.common.model.req.KycDictionaryReq;
import com.js.common.model.vo.KycDictionaryVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 字典表服务接口
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Path("apiKycDictionary")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycDictionaryService {

    /**
     * @Author liuh
     * @Description 根据type查找字典表信息
     * @Date 2019/5/18
     **/
    @GET
    @Path("dictionary")
    ResponseMessage findDictionary(String type,String code);

    /**
     * @Author liuh
     * @Description 查找字典表信息
     * @Date 2019/8/20
     **/
    @GET
    @Path("getKycDictionaryRootList")
    String getKycDictionaryRootList(KycDictionaryReq kycDictionaryReq);

    /**
     * @Author liuh
     * @Description 新增字典表信息
     * @Date 2019/8/21
     **/
    @GET
    @Path("addKycDictionary")
    int addKycDictionary(KycDictionaryReq kycDictionaryReq);

    /**
     * @Author liuh
     * @Description 编辑字典表信息
     * @Date 2019/8/21
     **/
    @GET
    @Path("updateKycDictionary")
    int updateKycDictionary(KycDictionaryReq kycDictionaryReq);

    /**
     * @Author liuh
     * @Description 根据ID查找字典表信息
     * @Date 2019/8/21
     **/
    @GET
    @Path("getDictionary")
    KycDictionaryVO getDictionary(String id);
}
