package com.js.api.jspay.service;


import com.js.common.model.vo.JsPayXGServicesRecordVO;
import com.js.common.model.vo.KycXGantiMoneyServiceVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

/**
 * @Description: XG服务反洗钱检验
 * @Author: liwm
 * @Create: 2019-08-13
 **/
@Path("apiJsPayXGantiMoneyService")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPayXGantiMoneyService {

    /**
     * XG服务:反洗钱账户检查
     */
    @POST
    @Path("searchKycForXGantiMoney")
    ResponseMessage searchKycForXGantiMoney(KycXGantiMoneyServiceVO kycXGantiMoneyServiceVO);

    /**
     * 查看XG反洗钱审核记录信息
     * @param kycNaturalId
     * @return
     */
    @POST
    @Path("queryXGServicesRecord")
    JsPayXGServicesRecordVO queryXGServicesRecords(String kycNaturalId);

    /**
     * 反洗钱账户审核变更
     * @param id
     * @param status
     * @return
     */
    @POST
    @Path("updateXGServicesStatusById")
    @Transactional
    ResponseMessage updateXGServicesStatusById(String id,String status);
}
