package com.js.api.jspay.service.chinapnr;

import com.js.common.model.req.ChinaPNRTransactionDetailsReq;
import com.js.common.model.req.ChinaPNRTransactionReq;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 汇付国际交易明细案
 *
 * @author: liutianyu
 * @date: 2019-07-01
 **/
@Path("chinaPNRPayTransactionDetails")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ChinaPNRTransactionDetailsService {

    ResponseMessage saveChinaPNRTransactionDetail(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq);
    /**
     * 提交结汇明细(订单还原)
     *
     * @param chinaPNRTransactionReq
     * @return
     */
    @POST
    @Path("submitTransactionDetails")
    @Transactional
    ResponseMessage submitTransactionDetails(ChinaPNRTransactionReq chinaPNRTransactionReq);

    /**
     * 重推结汇明细
     *
     * @param chinaPNRTransactionDetailsReq
     * @return
     */
    @POST
    @Path("reSubmitTransactionDetails")
    @Transactional
    ResponseMessage reSubmitTransactionDetails(ChinaPNRTransactionDetailsReq chinaPNRTransactionDetailsReq);

    @POST
    @Path("transactionDetailsCallback")
    ResponseMessage transactionDetailsCallback(String responseStr);

}
