package com.js.api.jspay.service;

import com.js.common.model.req.CertiMainLandPersonalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 大陆个人操作服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
@Path("apiKycCertiMainLandPersonal")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiKycCertiMainLandPersonalService {

    /**
     * @Author liuh
     * @Description 实名认证-大陆个人-保存
     * @Date 2019/5/21
     **/
    @POST
    @Path("certiMainLandPersonal")
    @Transactional
    ResponseMessage certiMainLandPersonalAdd(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 校验大陆个人是否存在
     * @Date 2019/6/5
     **/
    @GET
    @Path("verifyCertiMainLandPersonExists")
    boolean verifyCertiMainLandPersonExists(String idNo);

    /**
     * @Author liuh
     * @Description 实名认证-大陆个人-更新
     * @Date 2019/8/5
     **/
    @PUT
    @Path("certiMainLandPersonalUpdate")
    @Transactional
    ResponseMessage certiMainLandPersonalUpdate(CertiMainLandPersonalReq certiMainLandPersonalReq, KycNaturalVO kycNaturalVO);
}
