package com.js.api.jspay.service;

import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.JsPayVatPaymentRcvListReq;
import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.transaction.annotation.Transactional;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("apiJsPayVatPaymentInfo")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPayVatPaymentInfoService {

    /**
     * 查询VAT缴税的收款人列表
     */
    @GET
    @Path("queryRcvList")
    ResponseMessage queryRcvList(String kycNaturalId);

    @GET
    @Path("queryVatList")
    ResponseMessage queryVatList(String str);

    /**
     * 新增VAT缴税记录
     */
    @POST
    @Path("addPayVatPaymentInfo")
    @Transactional
    ResponseMessage addPayVatPaymentInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq);

    /**
     *  vat缴税记录到DB
     * @param jsPayVatPaymentInfoReq
     * @return
     */
    @POST
    @Path("addVatPayTrade")
    @Transactional
    ResponseMessage addVatPayTrade(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, KycNaturalVO kycNaturalVO);

    /**
     *  vat缴税信息更新
     * @param jsPayVatPaymentInfoReq
     * @param id
     * @return
     */
    @POST
    @Path("updatePayVatPaymentInfo")
    @Transactional
    ResponseMessage updatePayVatPaymentInfo(JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq,String id);

    /**
     * 受益人审核结果通知，VAT缴税处理oiuydsazsxfvghnjmkl;'';lkjhgfz  QW3E456790-.
     * @param beneficiayId
     * @return
     */
    @POST
    @Path("updatePayVatPaymentInfo")
    @Transactional
    ResponseMessage beneficiayAuditNotice(String beneficiayId);
}
