package com.js.api.jspay.service;

import com.js.common.model.req.*;
import com.js.common.model.vo.JsPaySunrateBankTradeInVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @Description: 寻汇通知合作方交互接口
 * @Author: liuh
 * @Create: 2019-06-03
 **/
@Path("apiKycSunRateBankTradeIn")
@Produces({MediaType.APPLICATION_JSON, MediaType.TEXT_XML})
public interface ApiJsPaySunrateBankTradeInService {
    /**
     * @Author liuh
     * @Description 寻汇 -> 合作方 入账通知 接口
     * @Date 2019/6/3
     **/
    @POST
    @Path("bankTradeInNotice")
    ResponseMessage bankTradeInNotice(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq);

    /**
     * @Author liuh
     * @Description 入账列表
     * @Date 2019/6/11
     **/
    @GET
    @Path("tradeInList")
    ResponseMessage tradeInList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 入账详情
     * @Date 2019/6/15
     **/
    @GET
    @Path("tradeInDetail")
    ResponseMessage tradeInDetail(String tradeInId);

    /**
     * @Author liuh
     * @Description 入账列表
     * @Date 2019/7/9
     **/
    @GET
    @Path("manageTradeInList")
    String manageTradeInList(JsTradeListReq jsTradeListReq);

    /**
     * @Author liuh
     * @Description 查找入账信息
     * @Date 2019/6/3
     **/
    @POST
    @Path("findBankTradeIn")
    JsPaySunrateBankTradeInVO findBankTradeIn(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq);
}
